/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.TreeSet;
import org.axonframework.common.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CollectionUtilsTest {
    CollectionUtilsTest() {
    }

    @Test
    void createCollectionFromPotentialCollection() {
        Collection collectionFromElement = CollectionUtils.asCollection((Object)"item");
        Collection collectionFromNull = CollectionUtils.asCollection(null);
        Collection collectionFromArray = CollectionUtils.asCollection((Object)new String[]{"item1", "item2"});
        Collection collectionFromCollection = CollectionUtils.asCollection(Arrays.asList("item1", "item2"));
        Collection collectionFromSpliterator = CollectionUtils.asCollection(Spliterators.spliterator(new String[]{"item1", "item2"}, 16));
        Collection collectionFromIterable = CollectionUtils.asCollection(() -> Arrays.asList("item1", "item2").iterator());
        Assertions.assertEquals((int)1, (int)collectionFromElement.size());
        Assertions.assertEquals((int)0, (int)collectionFromNull.size());
        Assertions.assertEquals((int)2, (int)collectionFromArray.size());
        Assertions.assertEquals((int)2, (int)collectionFromCollection.size());
        Assertions.assertEquals((int)2, (int)collectionFromSpliterator.size());
        Assertions.assertEquals((int)2, (int)collectionFromIterable.size());
    }

    @Test
    void intersect() {
        TreeSet result1 = (TreeSet)CollectionUtils.intersect(Arrays.asList(1, 2, 4, 5), Arrays.asList(1, 3, 5, 7), TreeSet::new);
        TreeSet result2 = (TreeSet)CollectionUtils.intersect(Collections.emptyList(), Arrays.asList(1, 3, 5, 7), TreeSet::new);
        List result3 = (List)CollectionUtils.intersect(Collections.singletonList(1), Arrays.asList(1, 3, 5, 7), ArrayList::new);
        Assertions.assertEquals(new TreeSet<Integer>(Arrays.asList(1, 5)), (Object)result1);
        Assertions.assertEquals(new TreeSet(), (Object)result2);
        Assertions.assertEquals(Collections.singletonList(1), (Object)result3);
    }
}

