/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.time.Instant;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import org.axonframework.common.DateTimeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DateTimeUtilsTest {
    DateTimeUtilsTest() {
    }

    @Test
    void formattedDateAlwaysContainsMillis() {
        Instant now = Instant.now();
        Instant nowAtZeroMillis = now.minusNanos(now.get(ChronoField.NANO_OF_SECOND));
        String formatted = DateTimeUtils.formatInstant((TemporalAccessor)nowAtZeroMillis);
        Assertions.assertTrue((boolean)formatted.matches(".*\\.0{3,}Z"), (String)("Time doesn't seem to contain explicit millis: " + formatted));
        Assertions.assertEquals((Object)nowAtZeroMillis, (Object)DateTimeUtils.parseInstant((CharSequence)formatted));
    }

    @Test
    void formatInstantHasFixedPrecisionAtThree() {
        String expectedDateTimeString = "2021-03-22T15:41:02.101Z";
        Instant testInstantWithTrailingZeroes = Instant.parse("2021-03-22T15:41:02.101900Z");
        Instant testInstantWithTrailingNonZeroes = Instant.parse("2021-03-22T15:41:02.101911Z");
        Instant testInstantWithoutTrailingZeroes = Instant.parse("2021-03-22T15:41:02.1019Z");
        Instant testInstantWithoutMillis = Instant.parse("2021-03-22T15:41:02Z");
        Assertions.assertEquals((Object)expectedDateTimeString, (Object)DateTimeUtils.formatInstant((TemporalAccessor)testInstantWithTrailingZeroes));
        Assertions.assertEquals((Object)expectedDateTimeString, (Object)DateTimeUtils.formatInstant((TemporalAccessor)testInstantWithTrailingNonZeroes));
        Assertions.assertEquals((Object)expectedDateTimeString, (Object)DateTimeUtils.formatInstant((TemporalAccessor)testInstantWithoutTrailingZeroes));
        Assertions.assertEquals((Object)"2021-03-22T15:41:02.000Z", (Object)DateTimeUtils.formatInstant((TemporalAccessor)testInstantWithoutMillis));
    }
}

