/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.axonframework.common.ExceptionUtils;
import org.axonframework.common.ProcessRetriesExhaustedException;
import org.axonframework.common.ProcessUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ProcessUtilsTest {
    ProcessUtilsTest() {
    }

    @Test
    void executeWithRetry() {
        AtomicLong retryCounter = new AtomicLong();
        ProcessUtils.executeWithRetry(() -> {
            if (retryCounter.getAndIncrement() < 5L) {
                throw new IllegalArgumentException("Waiting for 5");
            }
        }, e -> ExceptionUtils.findException((Throwable)e, IllegalArgumentException.class).isPresent(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (long)10L);
        Assertions.assertEquals((long)6L, (long)retryCounter.get());
    }

    @Test
    void executeWithRetryStops() {
        AtomicLong retryCounter = new AtomicLong();
        Assertions.assertThrows(IllegalArgumentException.class, () -> ProcessUtils.executeWithRetry(() -> {
            if (retryCounter.getAndIncrement() < 11L) {
                throw new IllegalArgumentException("Waiting for 11");
            }
        }, e -> ExceptionUtils.findException((Throwable)e, IllegalArgumentException.class).isPresent(), (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (long)10L));
    }

    @Test
    void executeWithRetryImmediatelyStopsOnOther() {
        AtomicLong retryCounter = new AtomicLong();
        try {
            ProcessUtils.executeWithRetry(() -> {
                if (retryCounter.getAndIncrement() < 11L) {
                    throw new IllegalArgumentException("Waiting for 11");
                }
            }, e -> false, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS, (long)10L);
            Assertions.fail((String)"Should not get here");
        }
        catch (Exception ex) {
            Assertions.assertTrue((boolean)(ex instanceof IllegalArgumentException));
            Assertions.assertEquals((long)1L, (long)retryCounter.get());
        }
    }

    @Test
    void executeUntilTrueRetries() {
        AtomicLong retryCounter = new AtomicLong();
        ProcessUtils.executeUntilTrue(() -> retryCounter.getAndIncrement() >= 1L, (long)10L, (long)10L);
        Assertions.assertEquals((long)2L, (long)retryCounter.get());
    }

    @Test
    void executeUntilTrueThrowsWhenMaxRetriesReached() {
        AtomicLong retryCounter = new AtomicLong();
        Assertions.assertThrows(ProcessRetriesExhaustedException.class, () -> ProcessUtils.executeUntilTrue(() -> retryCounter.getAndIncrement() >= 100L, (long)1L, (long)10L));
        Assertions.assertEquals((long)10L, (long)retryCounter.get());
    }
}

