/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import org.axonframework.common.ReflectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ReflectionUtilsTest {
    ReflectionUtilsTest() {
    }

    @Test
    void findFieldsInClass() {
        Iterable actualFields = ReflectionUtils.fieldsOf(SomeSubType.class);
        int t = 0;
        for (Field actual : actualFields) {
            if (actual.isSynthetic()) continue;
            switch (t++) {
                case 0: {
                    Assertions.assertEquals((Object)"field3", (Object)actual.getName());
                    break;
                }
                case 1: 
                case 2: {
                    Assertions.assertTrue(("field1".equals(actual.getName()) || "field2".equals(actual.getName()) ? 1 : 0) != 0, (String)("Expected either field1 or field2, but got " + actual.getName() + " declared in " + actual.getDeclaringClass().getName()));
                }
            }
        }
        Assertions.assertTrue((t >= 2 ? 1 : 0) != 0);
    }

    @Test
    void nonRecursivelyFindFieldsInClass() {
        Iterable actualFields = ReflectionUtils.fieldsOf(SomeSubType.class, (boolean)false);
        int t = 0;
        for (Field actual : actualFields) {
            if (actual.isSynthetic()) continue;
            Assertions.assertEquals((Object)"field3", (Object)actual.getName());
            ++t;
        }
        Assertions.assertTrue((t >= 1 ? 1 : 0) != 0);
    }

    @Test
    void findMethodsInClass() {
        Iterable actualMethods = ReflectionUtils.methodsOf(SomeSubType.class);
        int t = 0;
        for (Method actual : actualMethods) {
            if (actual.isSynthetic()) continue;
            switch (t++) {
                case 0: {
                    Assertions.assertEquals((Object)"getField3", (Object)actual.getName());
                    break;
                }
                case 1: {
                    Assertions.assertEquals((Object)"getField3", (Object)actual.getName());
                    Assertions.assertEquals((Object)"SomeSubInterface", (Object)actual.getDeclaringClass().getSimpleName());
                    break;
                }
                case 2: 
                case 3: {
                    Assertions.assertTrue(("getField1".equals(actual.getName()) || "getField2".equals(actual.getName()) ? 1 : 0) != 0, (String)("Expected either getField1 or getField2, but got " + actual.getName() + " declared in " + actual.getDeclaringClass().getName()));
                    break;
                }
                case 4: {
                    Assertions.assertEquals((Object)"SomeInterface", (Object)actual.getDeclaringClass().getSimpleName());
                }
            }
        }
        Assertions.assertTrue((t >= 4 ? 1 : 0) != 0);
    }

    @Test
    void nonRecursivelyFindMethodsInClass() {
        Iterable actualMethods = ReflectionUtils.methodsOf(SomeSubType.class, (boolean)false);
        int t = 0;
        for (Method actual : actualMethods) {
            if (actual.isSynthetic()) continue;
            switch (t++) {
                case 0: {
                    Assertions.assertEquals((Object)"getField3", (Object)actual.getName());
                    break;
                }
                case 1: {
                    Assertions.assertEquals((Object)"getField3", (Object)actual.getName());
                    Assertions.assertEquals((Object)"SomeSubInterface", (Object)actual.getDeclaringClass().getSimpleName());
                }
            }
        }
        Assertions.assertTrue((t >= 2 ? 1 : 0) != 0);
    }

    @Test
    void getFieldValue() throws NoSuchFieldException {
        Object value = ReflectionUtils.getFieldValue((Field)SomeType.class.getDeclaredField("field1"), (Object)new SomeSubType());
        Assertions.assertEquals((Object)"field1", (Object)value);
    }

    @Test
    void setFieldValue() throws Exception {
        int expectedFieldValue = 4;
        SomeSubType testObject = new SomeSubType();
        ReflectionUtils.setFieldValue((Field)SomeSubType.class.getDeclaredField("field3"), (Object)testObject, (Object)expectedFieldValue);
        Assertions.assertEquals((int)expectedFieldValue, (int)testObject.getField3());
    }

    @Test
    void isAccessible() throws NoSuchFieldException {
        Field field1 = SomeType.class.getDeclaredField("field1");
        Field field2 = SomeType.class.getDeclaredField("field2");
        Field field3 = SomeSubType.class.getDeclaredField("field3");
        Assertions.assertFalse((boolean)ReflectionUtils.isAccessible((AccessibleObject)field1));
        Assertions.assertFalse((boolean)ReflectionUtils.isAccessible((AccessibleObject)field2));
        Assertions.assertTrue((boolean)ReflectionUtils.isAccessible((AccessibleObject)field3));
    }

    @Test
    void explicitlyUnequal_NullValues() {
        Assertions.assertFalse((boolean)ReflectionUtils.explicitlyUnequal(null, null));
        Assertions.assertTrue((boolean)ReflectionUtils.explicitlyUnequal(null, (Object)""));
        Assertions.assertTrue((boolean)ReflectionUtils.explicitlyUnequal((Object)"", null));
    }

    @Test
    void hasEqualsMethodTest() {
        Assertions.assertTrue((boolean)ReflectionUtils.hasEqualsMethod(String.class));
        Assertions.assertTrue((boolean)ReflectionUtils.hasEqualsMethod(ArrayList.class));
        Assertions.assertFalse((boolean)ReflectionUtils.hasEqualsMethod(SomeType.class));
    }

    @Test
    void explicitlyUnequal_ComparableValues() {
        Assertions.assertFalse((boolean)ReflectionUtils.explicitlyUnequal((Object)"value", (Object)new String("value")));
        Assertions.assertTrue((boolean)ReflectionUtils.explicitlyUnequal((Object)"value1", (Object)"value2"));
    }

    @Test
    void explicitlyUnequal_OverridesEqualsMethod() {
        Assertions.assertFalse((boolean)ReflectionUtils.explicitlyUnequal(Collections.singletonList("value"), Collections.singletonList("value")));
        Assertions.assertTrue((boolean)ReflectionUtils.explicitlyUnequal(Collections.singletonList("value1"), Collections.singletonList("value")));
    }

    @Test
    void explicitlyUnequal_NoEqualsOrComparable() {
        Assertions.assertFalse((boolean)ReflectionUtils.explicitlyUnequal((Object)new SomeType(), (Object)new SomeType()));
    }

    @Test
    void resolvePrimitiveWrapperTypeForLong() {
        Assertions.assertEquals(Long.class, (Object)ReflectionUtils.resolvePrimitiveWrapperType(Long.TYPE));
    }

    @Test
    void getMemberValueFromField() throws NoSuchFieldException {
        Assertions.assertEquals((Object)"field1", (Object)ReflectionUtils.getMemberValue((Member)SomeType.class.getDeclaredField("field1"), (Object)new SomeSubType()));
    }

    @Test
    void getMemberValueFromMethod() throws NoSuchMethodException {
        Assertions.assertEquals((Object)"field1", (Object)ReflectionUtils.getMemberValue((Member)SomeType.class.getDeclaredMethod("getField1", new Class[0]), (Object)new SomeSubType()));
        Assertions.assertEquals((Object)"someMethodResult", (Object)ReflectionUtils.getMemberValue((Member)SomeTypeWithMethods.class.getDeclaredMethod("someMethod", new Class[0]), (Object)new SomeTypeWithMethods()));
    }

    @Test
    void getMemberValueFromVoidMethod() throws NoSuchMethodException {
        SomeTypeWithMethods testObject = new SomeTypeWithMethods();
        Object voidReturnValue = ReflectionUtils.getMemberValue((Member)SomeTypeWithMethods.class.getDeclaredMethod("someVoidMethod", new Class[0]), (Object)testObject);
        Assertions.assertNull((Object)voidReturnValue);
        Assertions.assertEquals((int)1, (int)testObject.voidMethodInvocations.get());
    }

    @Test
    void getMemberValueFromConstructor() throws NoSuchMethodException {
        Constructor testConstructor = SomeType.class.getDeclaredConstructor(new Class[0]);
        SomeSubType testTarget = new SomeSubType();
        Assertions.assertThrows(IllegalStateException.class, () -> ReflectionUtils.getMemberValue((Member)testConstructor, (Object)testTarget));
    }

    @Test
    void getMemberValueTypeFromField() throws NoSuchFieldException {
        Class fieldType = ReflectionUtils.getMemberValueType((Member)SomeType.class.getDeclaredField("field1"));
        Assertions.assertEquals(String.class, (Object)fieldType);
    }

    @Test
    void getMemberValueTypeFromMethod() throws NoSuchMethodException {
        Class methodValueType = ReflectionUtils.getMemberValueType((Member)SomeSubType.class.getDeclaredMethod("getField3", new Class[0]));
        Assertions.assertEquals(Integer.TYPE, (Object)methodValueType);
        Class voidResultType = ReflectionUtils.getMemberValueType((Member)SomeTypeWithMethods.class.getDeclaredMethod("someVoidMethod", new Class[0]));
        Assertions.assertEquals(Void.TYPE, (Object)voidResultType);
    }

    @Test
    void getMemberValueTypeFromConstructor() throws NoSuchMethodException {
        Constructor testConstructor = SomeType.class.getDeclaredConstructor(new Class[0]);
        Assertions.assertThrows(IllegalStateException.class, () -> ReflectionUtils.getMemberValueType((Member)testConstructor));
    }

    @Test
    void invokeAndGetMethodValueTest() throws NoSuchMethodException {
        Assertions.assertEquals((Object)"field1", (Object)ReflectionUtils.invokeAndGetMethodValue((Method)SomeTypeWithMethods.class.getDeclaredMethod("getField1", new Class[0]), (Object)new SomeTypeWithMethods()));
        Assertions.assertEquals((Object)"someMethodResult", (Object)ReflectionUtils.invokeAndGetMethodValue((Method)SomeTypeWithMethods.class.getDeclaredMethod("someMethod", new Class[0]), (Object)new SomeTypeWithMethods()));
        SomeTypeWithMethods testObject = new SomeTypeWithMethods();
        Object voidMethodResult = ReflectionUtils.invokeAndGetMethodValue((Method)SomeTypeWithMethods.class.getDeclaredMethod("someVoidMethod", new Class[0]), (Object)testObject);
        Assertions.assertNull((Object)voidMethodResult);
        Assertions.assertEquals((int)1, (int)testObject.voidMethodInvocations.get());
    }

    @Test
    void memberGenericTypeFromField() throws NoSuchFieldException {
        Field field = SomeType.class.getDeclaredField("field1");
        Type memberGenericType = ReflectionUtils.getMemberGenericType((Member)field);
        Assertions.assertEquals((Object)field.getGenericType(), (Object)memberGenericType);
    }

    @Test
    void memberGenericTypeFromMethod() throws NoSuchMethodException {
        Method method = SomeTypeWithMethods.class.getDeclaredMethod("someMethod", new Class[0]);
        Type memberGenericType = ReflectionUtils.getMemberGenericType((Member)method);
        Assertions.assertEquals((Object)method.getGenericReturnType(), (Object)memberGenericType);
    }

    @Test
    void memberGenericTypeFromConstructor() throws NoSuchMethodException {
        Constructor constructor = SomeTypeWithMethods.class.getDeclaredConstructor(new Class[0]);
        Assertions.assertThrows(IllegalStateException.class, () -> ReflectionUtils.getMemberGenericType((Member)constructor));
    }

    @Test
    void memberGenericStringFromField() throws NoSuchFieldException {
        Field field = SomeType.class.getDeclaredField("field1");
        String memberGenericString = ReflectionUtils.getMemberGenericString((Member)field);
        Assertions.assertEquals((Object)field.toGenericString(), (Object)memberGenericString);
    }

    @Test
    void memberGenericStringFromMethod() throws NoSuchMethodException {
        Method method = SomeTypeWithMethods.class.getDeclaredMethod("someMethod", new Class[0]);
        String memberGenericString = ReflectionUtils.getMemberGenericString((Member)method);
        Assertions.assertEquals((Object)method.toGenericString(), (Object)memberGenericString);
    }

    @Test
    void memberGenericStringFromConstructor() throws NoSuchMethodException {
        Constructor constructor = SomeTypeWithMethods.class.getDeclaredConstructor(new Class[0]);
        String memberGenericString = ReflectionUtils.getMemberGenericString(constructor);
        Assertions.assertEquals((Object)constructor.toGenericString(), (Object)memberGenericString);
    }

    @Test
    void toDiscernableSignatureOfConstructor() throws NoSuchMethodException {
        Constructor constructor = SomeTypeWithMethods.class.getDeclaredConstructor(new Class[0]);
        String memberGenericString = ReflectionUtils.toDiscernibleSignature(constructor);
        Assertions.assertEquals((Object)"org.axonframework.common.ReflectionUtilsTest$SomeTypeWithMethods()", (Object)memberGenericString);
    }

    @Test
    void toDiscernableSignatureOfMethod() throws NoSuchMethodException {
        Method method = SomeTypeWithMethods.class.getMethod("someMethodWithParameters", String.class, Integer.class, Object.class);
        String memberGenericString = ReflectionUtils.toDiscernibleSignature((Executable)method);
        Assertions.assertEquals((Object)"someMethodWithParameters(java.lang.String,java.lang.Integer,java.lang.Object)", (Object)memberGenericString);
    }

    private static class SomeTypeWithMethods
    implements SomeInterface {
        public AtomicInteger voidMethodInvocations = new AtomicInteger();

        private SomeTypeWithMethods() {
        }

        @Override
        public String getField1() {
            return "field1";
        }

        public String someMethod() {
            return "someMethodResult";
        }

        public void someVoidMethod() {
            this.voidMethodInvocations.incrementAndGet();
        }

        public String someMethodWithParameters(String parameterOne, Integer parameterTwo, Object parameter3) {
            return "someMethodWithParametersResult";
        }
    }

    public static class SomeSubType
    extends SomeType
    implements SomeSubInterface {
        public int field3 = 3;

        @Override
        public int getField3() {
            return this.field3;
        }
    }

    public static interface SomeSubInterface {
        public int getField3();
    }

    public static interface SomeInterface {
        public String getField1();
    }

    private static class SomeType
    implements SomeInterface {
        private final String field1 = "field1";
        private final String field2 = "field2";

        private SomeType() {
        }

        @Override
        public String getField1() {
            return "field1";
        }

        public String getField2() {
            return "field2";
        }
    }
}

