/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import org.axonframework.common.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StringUtilsTest {
    StringUtilsTest() {
    }

    @Test
    void nonEmptyOrNullReturnsFalseForEmptyString() {
        Assertions.assertFalse((boolean)StringUtils.nonEmptyOrNull((String)""));
    }

    @Test
    void nonEmptyOrNullReturnsFalseForNullString() {
        Assertions.assertFalse((boolean)StringUtils.nonEmptyOrNull(null));
    }

    @Test
    void nonEmptyOrNullReturnsTrueForNonEmptyString() {
        Assertions.assertTrue((boolean)StringUtils.nonEmptyOrNull((String)"some-string"));
    }

    @Test
    void emptyOrNullReturnsTrueForEmptyStrings() {
        Assertions.assertTrue((boolean)StringUtils.emptyOrNull((String)""));
    }

    @Test
    void emptyOrNullReturnsTrueForNullString() {
        Assertions.assertTrue((boolean)StringUtils.emptyOrNull(null));
    }

    @Test
    void emptyOrNullReturnsFalseForNonEmptyString() {
        Assertions.assertFalse((boolean)StringUtils.emptyOrNull((String)"some-string"));
    }

    @Test
    void lowerCaseFirstCharacterOfAdjustsFirstCharacterToLowerCase() {
        String fullUppercase = "FOO";
        String lowerCasedOutputOfFullUppercase = "fOO";
        Assertions.assertEquals((Object)lowerCasedOutputOfFullUppercase, (Object)StringUtils.lowerCaseFirstCharacterOf((String)fullUppercase));
        Assertions.assertEquals((Object)lowerCasedOutputOfFullUppercase, (Object)StringUtils.lowerCaseFirstCharacterOf((String)lowerCasedOutputOfFullUppercase));
        String partialUppercase = "FOo";
        String partialLowercase = "fOo";
        Assertions.assertEquals((Object)partialLowercase, (Object)StringUtils.lowerCaseFirstCharacterOf((String)partialUppercase));
        Assertions.assertEquals((Object)partialLowercase, (Object)StringUtils.lowerCaseFirstCharacterOf((String)partialLowercase));
    }
}

