/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.caching;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.awaitility.Awaitility;
import org.axonframework.common.Registration;
import org.axonframework.common.caching.AbstractCacheAdapter;
import org.axonframework.common.caching.Cache;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public abstract class AbstractCacheAdapterTest {
    private TestSubjectWrapper testSubjectWrapper;
    private AbstractCacheAdapter testSubject;
    private Cache.EntryListener mockListener;
    private Registration registration;

    abstract TestSubjectWrapper getTestSubjectWrapper();

    @BeforeEach
    void setUp() {
        this.testSubjectWrapper = this.getTestSubjectWrapper();
        this.testSubject = this.testSubjectWrapper.testSubject;
        this.mockListener = (Cache.EntryListener)Mockito.mock(Cache.EntryListener.class);
        this.registration = this.testSubject.registerCacheEntryListener(this.mockListener);
    }

    @AfterEach
    void tearDown() {
        Mockito.reset((Object[])new Cache.EntryListener[]{this.mockListener});
        this.testSubjectWrapper.closeFunction.run();
    }

    @Test
    void removeAllRemovesAllEntries() {
        this.testSubject.put((Object)"one", new Object());
        this.testSubject.put((Object)"two", new Object());
        this.testSubject.put((Object)"three", new Object());
        this.testSubject.put((Object)"four", new Object());
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"one"));
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"two"));
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"three"));
        Assertions.assertTrue((boolean)this.testSubject.containsKey((Object)"four"));
        this.testSubject.removeAll();
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"one"));
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"two"));
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"three"));
        Assertions.assertFalse((boolean)this.testSubject.containsKey((Object)"four"));
    }

    @Test
    void computeIfPresentDoesNotUpdateNonExistingEntry() {
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.testSubject.computeIfPresent((Object)"some-key", v -> {
            invoked.set(true);
            return v;
        });
        Assertions.assertFalse((boolean)invoked.get());
    }

    @Test
    void computeIfPresentUpdatesExistingEntry() {
        String testKey = "some-key";
        this.testSubject.put((Object)testKey, new Object());
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.testSubject.computeIfPresent((Object)testKey, v -> {
            invoked.set(true);
            return v;
        });
        Assertions.assertTrue((boolean)invoked.get());
    }

    @Test
    void putIfAbsentWorksCorrectly() {
        Object value = new Object();
        Object value2 = new Object();
        this.testSubject.putIfAbsent((Object)"test1", value);
        Assertions.assertEquals((Object)value, (Object)this.testSubject.get((Object)"test1"));
        this.testSubject.putIfAbsent((Object)"test1", value2);
        Assertions.assertEquals((Object)value, (Object)this.testSubject.get((Object)"test1"));
    }

    @Test
    void entryListenerNotifiedOfCreationUpdateAndDeletion() {
        Object value = new Object();
        Object value2 = new Object();
        this.testSubject.put((Object)"test1", value);
        Awaitility.await().atMost(Duration.ofMillis(300L)).untilAsserted(() -> ((Cache.EntryListener)Mockito.verify((Object)this.mockListener)).onEntryCreated((Object)"test1", value));
        this.testSubject.put((Object)"test1", value2);
        Awaitility.await().atMost(Duration.ofMillis(300L)).untilAsserted(() -> ((Cache.EntryListener)Mockito.verify((Object)this.mockListener)).onEntryUpdated((Object)"test1", value2));
        this.testSubject.remove((Object)"test1");
        Awaitility.await().atMost(Duration.ofMillis(300L)).untilAsserted(() -> ((Cache.EntryListener)Mockito.verify((Object)this.mockListener)).onEntryRemoved((Object)"test1"));
        Assertions.assertNull((Object)this.testSubject.get((Object)"test1"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockListener});
    }

    @Test
    void entryListenerNotifiedOfExpired() {
        Object value = new Object();
        this.testSubject.put((Object)"test1", value);
        Awaitility.await().atMost(Duration.ofMillis(300L)).untilAsserted(() -> ((Cache.EntryListener)Mockito.verify((Object)this.mockListener)).onEntryCreated((Object)"test1", value));
        Awaitility.await().atMost(Duration.ofSeconds(1L)).untilAsserted(() -> {
            this.testSubject.get((Object)"test1");
            ((Cache.EntryListener)Mockito.verify((Object)this.mockListener)).onEntryExpired((Object)"test1");
        });
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockListener});
    }

    @Test
    void entryListenerCanBeDeregistered() {
        Object value = new Object();
        Object value2 = new Object();
        this.testSubject.put((Object)"test1", value);
        Awaitility.await().atMost(Duration.ofMillis(300L)).untilAsserted(() -> ((Cache.EntryListener)Mockito.verify((Object)this.mockListener)).onEntryCreated((Object)"test1", value));
        this.registration.cancel();
        this.testSubject.put((Object)"test2", value2);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockListener});
    }

    static class TestSubjectWrapper {
        private final AbstractCacheAdapter testSubject;
        private final Runnable closeFunction;

        TestSubjectWrapper(AbstractCacheAdapter testSubject, Runnable closeFunction) {
            this.testSubject = testSubject;
            this.closeFunction = closeFunction;
        }
    }
}

