/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.axonframework.common.jdbc.ConnectionWrapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class ConnectionWrapperFactoryTest {
    private ConnectionWrapperFactory.ConnectionCloseHandler closeHandler;
    private Connection connection;

    ConnectionWrapperFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.closeHandler = (ConnectionWrapperFactory.ConnectionCloseHandler)Mockito.mock(ConnectionWrapperFactory.ConnectionCloseHandler.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
    }

    @Test
    void wrapperDelegatesAllButClose() throws Exception {
        Connection wrapped = ConnectionWrapperFactory.wrap((Connection)this.connection, (ConnectionWrapperFactory.ConnectionCloseHandler)this.closeHandler);
        wrapped.commit();
        ((ConnectionWrapperFactory.ConnectionCloseHandler)Mockito.verify((Object)this.closeHandler)).commit(this.connection);
        wrapped.getAutoCommit();
        ((Connection)Mockito.verify((Object)this.connection)).getAutoCommit();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.closeHandler});
        wrapped.close();
        ((Connection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.never())).close();
        ((ConnectionWrapperFactory.ConnectionCloseHandler)Mockito.verify((Object)this.closeHandler)).close(this.connection);
    }

    @Test
    void equals_WithWrapper() {
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        Connection wrapped = ConnectionWrapperFactory.wrap((Connection)this.connection, Runnable.class, (Object)runnable, (ConnectionWrapperFactory.ConnectionCloseHandler)this.closeHandler);
        Assertions.assertNotEquals((Object)wrapped, (Object)this.connection);
        Assertions.assertEquals((Object)wrapped, (Object)wrapped);
    }

    @Test
    void equals_WithoutWrapper() {
        Connection wrapped = ConnectionWrapperFactory.wrap((Connection)this.connection, (ConnectionWrapperFactory.ConnectionCloseHandler)this.closeHandler);
        Assertions.assertNotEquals((Object)wrapped, (Object)this.connection);
        Assertions.assertEquals((Object)wrapped, (Object)wrapped);
    }

    @Test
    void hashCode_WithWrapper() {
        Runnable runnable = (Runnable)Mockito.mock(Runnable.class);
        Connection wrapped = ConnectionWrapperFactory.wrap((Connection)this.connection, Runnable.class, (Object)runnable, (ConnectionWrapperFactory.ConnectionCloseHandler)this.closeHandler);
        Assertions.assertEquals((int)wrapped.hashCode(), (int)wrapped.hashCode());
    }

    @Test
    void hashCode_WithoutWrapper() {
        Connection wrapped = ConnectionWrapperFactory.wrap((Connection)this.connection, (ConnectionWrapperFactory.ConnectionCloseHandler)this.closeHandler);
        Assertions.assertEquals((int)wrapped.hashCode(), (int)wrapped.hashCode());
    }

    @Test
    void unwrapInvocationTargetException() throws Exception {
        Mockito.when((Object)this.connection.prepareStatement(Mockito.anyString())).thenThrow(new Throwable[]{new SQLException()});
        Connection wrapper = ConnectionWrapperFactory.wrap((Connection)this.connection, (ConnectionWrapperFactory.ConnectionCloseHandler)this.closeHandler);
        Assertions.assertThrows(SQLException.class, () -> wrapper.prepareStatement("foo"));
    }

    @Test
    void unwrapInvocationTargetExceptionWithAdditionalWrapperInterface1() throws Exception {
        WrapperInterface wrapperImplementation = (WrapperInterface)Mockito.mock(WrapperInterface.class);
        Mockito.when((Object)this.connection.prepareStatement(Mockito.anyString())).thenThrow(new Throwable[]{new SQLException()});
        Connection wrapper = ConnectionWrapperFactory.wrap((Connection)this.connection, WrapperInterface.class, (Object)wrapperImplementation, (ConnectionWrapperFactory.ConnectionCloseHandler)this.closeHandler);
        Assertions.assertThrows(SQLException.class, () -> wrapper.prepareStatement("foo"));
    }

    @Test
    void unwrapInvocationTargetExceptionWithAdditionalWrapperInterface2() throws Exception {
        WrapperInterface wrapperImplementation = (WrapperInterface)Mockito.mock(WrapperInterface.class);
        ((WrapperInterface)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)wrapperImplementation)).foo();
        WrapperInterface wrapper = (WrapperInterface)((Object)ConnectionWrapperFactory.wrap((Connection)this.connection, WrapperInterface.class, (Object)wrapperImplementation, (ConnectionWrapperFactory.ConnectionCloseHandler)this.closeHandler));
        Assertions.assertThrows(SQLException.class, wrapper::foo);
    }

    private static interface WrapperInterface {
        public void foo() throws SQLException;
    }
}

