/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.ResultSet;
import org.axonframework.common.jdbc.JdbcUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class JdbcUtilsTest {
    JdbcUtilsTest() {
    }

    @Test
    void nextAndExtract_EmptyResultSet() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)false);
        Assertions.assertNull((Object)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class));
    }

    @Test
    void nextAndExtract_NullValue() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)resultSet.getObject(1, Long.class)).thenReturn(null);
        Assertions.assertNull((Object)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class));
    }

    @Test
    void nextAndExtractWithDefault_DefaultValue() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Long defaultValue = 42L;
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)resultSet.getObject(1, Long.class)).thenReturn(null);
        Assertions.assertEquals((Long)defaultValue, (Long)((Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class, (Object)defaultValue)));
    }

    @Test
    void nextAndExtract_NonNullValue() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)resultSet.getObject(1, Long.class)).thenReturn((Object)10L);
        Assertions.assertEquals((Long)10L, (Long)((Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class)));
    }

    @Test
    void nextAndExtract_NonNullValue_WasNull() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)resultSet.getObject(1, Long.class)).thenReturn((Object)0L);
        Mockito.when((Object)resultSet.wasNull()).thenReturn((Object)true);
        Assertions.assertNull((Object)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class));
    }

    @Test
    void nextAndExtractWithDefault_NonNullValue_WasDefault() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Long defaultValue = 42L;
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)resultSet.getObject(1, Long.class)).thenReturn((Object)0L);
        Mockito.when((Object)resultSet.wasNull()).thenReturn((Object)true);
        Assertions.assertEquals((Long)defaultValue, (Long)((Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class, (Object)defaultValue)));
    }
}

