/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.jdbc.JdbcException;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.jdbc.PagingJdbcIterable;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.hsqldb.jdbc.JDBCDataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

class PagingJdbcIterableTest {
    private DataSource dataSource;
    private TransactionManager transactionManager;
    private PagingJdbcIterable<String> testSubject;

    PagingJdbcIterableTest() {
    }

    @BeforeEach
    void setUp() {
        this.dataSource = this.dataSource();
        this.transactionManager = this.transactionManager(this.dataSource);
        this.transactionManager.executeInTransaction(() -> {
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                JdbcUtils.executeUpdates((Connection)connection, e -> {
                    throw new JdbcException("Enable to prepare test_table", (Throwable)e);
                }, (JdbcUtils.SqlFunction[])new JdbcUtils.SqlFunction[]{c -> c.prepareStatement("DROP TABLE IF EXISTS test_table"), c -> c.prepareStatement("CREATE TABLE IF NOT EXISTS test_table (identifier VARCHAR(255) NOT NULL,idIndex BIGINT NOT NULL)")});
            }
            catch (SQLException e2) {
                throw new IllegalStateException("Enable to retrieve a Connection to prepare the test_table", e2);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        });
        this.testSubject = new PagingJdbcIterable(this.transactionManager, () -> {
            try {
                return this.dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }, (connection, offset, maxSize) -> {
            String sql = "SELECT * FROM test_table WHERE idIndex >=? LIMIT ?";
            PreparedStatement statement = connection.prepareStatement(sql);
            statement.setLong(1, offset);
            statement.setLong(2, maxSize);
            return statement;
        }, 10, resultSet -> resultSet.getString("identifier"), RuntimeException::new);
    }

    private DataSource dataSource() {
        JDBCDataSource dataSource = new JDBCDataSource();
        dataSource.setUrl("jdbc:hsqldb:mem:axontest");
        dataSource.setUser("sa");
        dataSource.setPassword("");
        return dataSource;
    }

    private TransactionManager transactionManager(DataSource dataSource) {
        DataSourceTransactionManager platformTransactionManager = new DataSourceTransactionManager(dataSource);
        return () -> this.lambda$transactionManager$7((PlatformTransactionManager)platformTransactionManager);
    }

    @Test
    void queriesJustOneItemAsOnePage() {
        String testId = IdentifierFactory.getInstance().generateIdentifier();
        this.addEntryAt(testId, 1L);
        List result = StreamSupport.stream(this.testSubject.spliterator(), false).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((Object)testId, result.get(0));
    }

    @Test
    void queriesMultiplePages() {
        List<String> expectedIds = IntStream.range(0, 102).mapToObj(String::valueOf).collect(Collectors.toList());
        expectedIds.forEach(expectedId -> this.addEntryAt((String)expectedId, Long.parseLong(expectedId)));
        List result = StreamSupport.stream(this.testSubject.spliterator(), false).collect(Collectors.toList());
        Assertions.assertEquals((int)expectedIds.size(), (int)result.size());
        expectedIds.forEach(resultId -> Assertions.assertTrue((boolean)result.contains(resultId)));
    }

    private void addEntryAt(String id, long index) {
        this.transactionManager.executeInTransaction(() -> {
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                JdbcUtils.executeUpdate((Connection)connection, c -> {
                    String sql = "INSERT INTO test_table (identifier, idIndex) VALUES(?,?)";
                    PreparedStatement statement = c.prepareStatement(sql);
                    statement.setString(1, id);
                    statement.setLong(2, index);
                    return statement;
                }, e -> new JdbcException("Enable to insert entry [" + id + "] at index [" + index + "]", (Throwable)e));
            }
            catch (SQLException e2) {
                throw new IllegalStateException("Enable to retrieve a Connection to insert entry [" + id + "] at index [" + index + "]", e2);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        });
    }

    @Test
    void throwsExceptionWhenNoItemPresent() {
        Assertions.assertThrows(NoSuchElementException.class, this.testSubject.iterator()::next);
    }

    private /* synthetic */ Transaction lambda$transactionManager$7(final PlatformTransactionManager platformTransactionManager) {
        final TransactionStatus transaction = platformTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        return new Transaction(){

            public void commit() {
                platformTransactionManager.commit(transaction);
            }

            public void rollback() {
                platformTransactionManager.rollback(transaction);
            }
        };
    }
}

