/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.UnitOfWorkAwareConnectionProviderWrapper;
import org.axonframework.messaging.ExecutionException;
import org.axonframework.messaging.GenericResultMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.ExecutionResult;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class UnitOfWorkAwareConnectionProviderWrapperTest {
    private ConnectionProvider mockConnectionProvider;
    private Connection mockConnection;
    private UnitOfWorkAwareConnectionProviderWrapper testSubject;

    UnitOfWorkAwareConnectionProviderWrapperTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.mockConnectionProvider = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        this.mockConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.mockConnectionProvider.getConnection()).thenReturn((Object)this.mockConnection);
        this.testSubject = new UnitOfWorkAwareConnectionProviderWrapper(this.mockConnectionProvider);
    }

    @AfterEach
    void tearDown() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
    }

    @Test
    void connectionReturnedImmediatelyWhenNoActiveUnitOfWork() throws SQLException {
        Connection actual = this.testSubject.getConnection();
        Assertions.assertSame((Object)actual, (Object)this.mockConnection);
    }

    @Test
    void connectionIsWrappedWhenUnitOfWorkIsActive() throws SQLException {
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        Connection actual = this.testSubject.getConnection();
        Assertions.assertNotSame((Object)actual, (Object)this.mockConnection);
        actual.close();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).close();
        uow.commit();
        ((Connection)Mockito.verify((Object)this.mockConnection)).close();
    }

    @Test
    void wrappedConnectionBlocksCommitCallsUntilUnitOfWorkCommit() throws SQLException {
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        Mockito.when((Object)this.mockConnection.getAutoCommit()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)false);
        Connection actual = this.testSubject.getConnection();
        actual.commit();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).commit();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).close();
        uow.commit();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockConnection});
        ((Connection)inOrder.verify((Object)this.mockConnection)).commit();
        ((Connection)inOrder.verify((Object)this.mockConnection)).close();
    }

    @Test
    void wrappedConnectionRollsBackCallsWhenUnitOfWorkRollback() throws SQLException {
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        Mockito.when((Object)this.mockConnection.getAutoCommit()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)false);
        Connection actual = this.testSubject.getConnection();
        actual.close();
        actual.commit();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).commit();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).close();
        uow.rollback();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockConnection});
        ((Connection)inOrder.verify((Object)this.mockConnection)).rollback();
        ((Connection)inOrder.verify((Object)this.mockConnection)).close();
    }

    @Test
    void originalExceptionThrewWhenRollbackFailed() throws SQLException {
        DefaultUnitOfWork uow = new DefaultUnitOfWork<Message<?>>(null){

            public ExecutionResult getExecutionResult() {
                return new ExecutionResult(GenericResultMessage.asResultMessage((Throwable)new IllegalArgumentException()));
            }
        };
        ((Connection)Mockito.doThrow(SQLException.class).when((Object)this.mockConnection)).rollback();
        uow.start();
        this.testSubject.getConnection();
        try {
            uow.rollback();
        }
        catch (ExecutionException e) {
            Assertions.assertEquals(IllegalArgumentException.class, e.getCause().getClass());
            Assertions.assertEquals(SQLException.class, e.getSuppressed()[0].getClass());
        }
    }

    @Test
    void innerUnitOfWorkCommitDoesNotCloseConnection() throws SQLException {
        Mockito.when((Object)this.mockConnection.getAutoCommit()).thenReturn((Object)false);
        Mockito.when((Object)this.mockConnection.isClosed()).thenReturn((Object)false);
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        Connection actualOuter = this.testSubject.getConnection();
        ((ConnectionProvider)Mockito.verify((Object)this.mockConnectionProvider, (VerificationMode)Mockito.times((int)1))).getConnection();
        DefaultUnitOfWork innerUow = DefaultUnitOfWork.startAndGet(null);
        Connection actualInner = this.testSubject.getConnection();
        ((ConnectionProvider)Mockito.verify((Object)this.mockConnectionProvider, (VerificationMode)Mockito.times((int)1))).getConnection();
        Assertions.assertSame((Object)actualOuter, (Object)actualInner);
        actualInner.close();
        actualInner.commit();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).commit();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).close();
        innerUow.commit();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).commit();
        ((Connection)Mockito.verify((Object)this.mockConnection, (VerificationMode)Mockito.never())).close();
        uow.commit();
        ((Connection)Mockito.verify((Object)this.mockConnection)).commit();
        ((Connection)Mockito.verify((Object)this.mockConnection)).close();
    }
}

