/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.lock;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.lock.Lock;
import org.axonframework.common.lock.LockFactory;
import org.axonframework.common.lock.PessimisticLockFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class LockFactoryTest {
    private static final int THREAD_COUNT = 4;
    private static final int ATTEMPTS = 3000;
    private LockFactory lockFactory;
    private String aggregateIdentifier;

    LockFactoryTest() {
    }

    @BeforeEach
    void setup() {
        this.lockFactory = PessimisticLockFactory.builder().build();
        this.aggregateIdentifier = UUID.randomUUID().toString();
    }

    @Test
    void obtainLock() {
        ExecutorService service = Executors.newFixedThreadPool(4);
        LockUnlock[] attempts = new LockUnlock[3000];
        for (int t = 0; t < 3000; ++t) {
            attempts[t] = new LockUnlock(t);
        }
        long startTime = System.currentTimeMillis();
        for (LockUnlock attempt : attempts) {
            service.submit(attempt);
        }
        service.shutdown();
        try {
            service.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Interrupted");
        }
        int failedAttempts = 0;
        for (LockUnlock attempt : attempts) {
            if (attempt.success) continue;
            ++failedAttempts;
        }
        Assertions.assertEquals((int)0, (int)failedAttempts, (String)"Failed LockUnlock count");
    }

    private class LockUnlock
    implements Runnable {
        private int instanceIndex;
        private boolean success;

        LockUnlock(int instanceIndex) {
            this.instanceIndex = instanceIndex;
        }

        @Override
        public void run() {
            int locksAcquired = 0;
            int locksReleased = 0;
            try {
                Lock lock = LockFactoryTest.this.lockFactory.obtainLock(LockFactoryTest.this.aggregateIdentifier);
                ++locksAcquired;
                lock.release();
                ++locksReleased;
                this.success = true;
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                sw.append("Failed ").append(Integer.toString(this.instanceIndex)).append(" aquired=").append(Integer.toString(locksAcquired)).append(" release=").append(Integer.toString(locksReleased)).append(" Exception:");
                PrintWriter writer = new PrintWriter(sw);
                e.printStackTrace(writer);
                System.out.println(sw.toString());
            }
        }
    }
}

