/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.property;

import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractPropertyAccessStrategyTest<T> {
    @Test
    void getValue() {
        Property<T> actualProperty = this.getProperty(this.regularPropertyName());
        Assertions.assertNotNull(actualProperty);
        Assertions.assertNotNull((Object)actualProperty.getValue(this.propertyHoldingInstance()));
    }

    @Test
    void getValue_BogusProperty() {
        Assertions.assertNull(this.getProperty(this.unknownPropertyName()));
    }

    @Test
    void getValue_ExceptionOnAccess() {
        Property<T> property = this.getProperty(this.exceptionPropertyName());
        Assertions.assertThrows(PropertyAccessException.class, () -> property.getValue(this.propertyHoldingInstance()));
    }

    @Test
    void voidReturnTypeRejected() {
        Property<T> property = this.getProperty(this.voidPropertyName());
        Assertions.assertNull(property, (String)"void methods should not be accepted as property");
    }

    protected abstract String voidPropertyName();

    protected abstract String exceptionPropertyName();

    protected abstract String regularPropertyName();

    protected abstract String unknownPropertyName();

    protected abstract T propertyHoldingInstance();

    protected abstract Property<T> getProperty(String var1);
}

