/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.property;

import org.axonframework.common.property.DirectPropertyAccessStrategy;
import org.axonframework.common.property.Property;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DirectPropertyAccessStrategyTest {
    DirectPropertyAccessStrategyTest() {
    }

    @Test
    void getValue() {
        Property<TestMessage> actualProperty = this.getProperty(this.regularPropertyName());
        Assertions.assertNotNull(actualProperty);
        Assertions.assertNotNull((Object)actualProperty.getValue((Object)this.propertyHoldingInstance()));
    }

    @Test
    void getValue_BogusProperty() {
        Assertions.assertNull(this.getProperty(this.unknownPropertyName()));
    }

    @Test
    void getValue_NullForPrivateProperty() {
        Assertions.assertNull(this.getProperty(this.privatePropertyName()));
    }

    @Test
    void overriddenPropertyValue() {
        Assertions.assertEquals((Object)"realValue", (Object)this.getProperty(this.overriddenPropertyName()).getValue((Object)this.propertyHoldingInstance()));
    }

    private String overriddenPropertyName() {
        return "overriddenProperty1";
    }

    private String privatePropertyName() {
        return "privateProperty1";
    }

    private String regularPropertyName() {
        return "property1";
    }

    private String unknownPropertyName() {
        return "unknownProperty";
    }

    private TestMessage propertyHoldingInstance() {
        return new TestMessage();
    }

    private Property<TestMessage> getProperty(String property) {
        return new DirectPropertyAccessStrategy().propertyFor(TestMessage.class, property);
    }

    class TestMessageParent {
        public String parentProperty1 = "parentProperty1Value";
        public String overriddenProperty1 = "realValue";

        TestMessageParent() {
        }
    }

    class TestMessage
    extends TestMessageParent {
        public String property1 = "property1Value";
        private Integer privateProperty1;
        private String overriddenProperty1 = "fakeValue";

        TestMessage() {
        }
    }
}

