/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline;

import org.axonframework.deadline.DeadlineManagerSpanFactory;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.deadline.DefaultDeadlineManagerSpanFactory;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.tracing.IntermediateSpanFactoryTest;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultDeadlineManagerSpanFactoryTest
extends IntermediateSpanFactoryTest<DefaultDeadlineManagerSpanFactory.Builder, DeadlineManagerSpanFactory> {
    DefaultDeadlineManagerSpanFactoryTest() {
    }

    @Test
    void createScheduleSpanWithDefaultSettings() {
        DeadlineMessage message = (DeadlineMessage)Mockito.mock(DeadlineMessage.class);
        this.test(spanFactory -> spanFactory.createScheduleSpan("myDeadline", "myDeadlineId", message), this.expectedSpan("DeadlineManager.scheduleDeadline(myDeadline)", TestSpanFactory.TestSpanType.DISPATCH).withMessage((Message<?>)message).expectAttribute("axon.deadlineId", "myDeadlineId"));
    }

    @Test
    void createScheduleSpanWithModifiedDeadlineIdAtrribute() {
        DeadlineMessage message = (DeadlineMessage)Mockito.mock(DeadlineMessage.class);
        this.test(builder -> builder.deadlineIdAttribute("this-is-a-stupidly-long-attribute-name"), spanFactory -> spanFactory.createScheduleSpan("myDeadline", "myDeadlineId", message), this.expectedSpan("DeadlineManager.scheduleDeadline(myDeadline)", TestSpanFactory.TestSpanType.DISPATCH).withMessage((Message<?>)message).expectAttribute("this-is-a-stupidly-long-attribute-name", "myDeadlineId"));
    }

    @Test
    void createCancelScheduleSpanWithDefaultSettings() {
        this.test(spanFactory -> spanFactory.createCancelScheduleSpan("myDeadline", "myDeadlineId"), this.expectedSpan("DeadlineManager.cancelDeadline(myDeadline)", TestSpanFactory.TestSpanType.INTERNAL).expectAttribute("axon.deadlineId", "myDeadlineId"));
    }

    @Test
    void createCancelScheduleSpanWithModifiedDeadlineIdAttribute() {
        this.test(builder -> builder.deadlineIdAttribute("this-is-a-stupidly-long-attribute-name"), spanFactory -> spanFactory.createCancelScheduleSpan("myDeadline", "myDeadlineId"), this.expectedSpan("DeadlineManager.cancelDeadline(myDeadline)", TestSpanFactory.TestSpanType.INTERNAL).expectAttribute("this-is-a-stupidly-long-attribute-name", "myDeadlineId"));
    }

    @Test
    void createCancelAllSpanWithDefaultSettings() {
        this.test(spanFactory -> spanFactory.createCancelAllSpan("myDeadline"), this.expectedSpan("DeadlineManager.cancelAllDeadlines(myDeadline)", TestSpanFactory.TestSpanType.INTERNAL));
    }

    @Test
    void createCancelAllWithinScopeSpanWithDefaultSettings() {
        ScopeDescriptor scope = (ScopeDescriptor)Mockito.mock(ScopeDescriptor.class);
        Mockito.when((Object)scope.scopeDescription()).thenReturn((Object)"myScopeDescription");
        this.test(spanFactory -> spanFactory.createCancelAllWithinScopeSpan("myDeadline", scope), this.expectedSpan("DeadlineManager.cancelAllWithinScope(myDeadline)", TestSpanFactory.TestSpanType.INTERNAL).expectAttribute("axon.deadlineScope", "myScopeDescription"));
    }

    @Test
    void createCancelAllWithinScopeSpanWithModifiedScopeAttribute() {
        ScopeDescriptor scope = (ScopeDescriptor)Mockito.mock(ScopeDescriptor.class);
        Mockito.when((Object)scope.scopeDescription()).thenReturn((Object)"myScopeDescription");
        this.test(builder -> builder.scopeAttribute("this-is-a-stupidly-long-attribute-name"), spanFactory -> spanFactory.createCancelAllWithinScopeSpan("myDeadline", scope), this.expectedSpan("DeadlineManager.cancelAllWithinScope(myDeadline)", TestSpanFactory.TestSpanType.INTERNAL).expectAttribute("this-is-a-stupidly-long-attribute-name", "myScopeDescription"));
    }

    @Test
    void createExecuteSpanWithDefaultSettings() {
        DeadlineMessage message = (DeadlineMessage)Mockito.mock(DeadlineMessage.class);
        this.test(spanFactory -> spanFactory.createExecuteSpan("myDeadline", "myDeadlineId", message), this.expectedSpan("DeadlineManager.executeDeadline(myDeadline)", TestSpanFactory.TestSpanType.HANDLER_LINK).withMessage((Message<?>)message).expectAttribute("axon.deadlineId", "myDeadlineId"));
    }

    @Test
    void createExecuteSpanWithModifiedDeadlineIdAtrribute() {
        DeadlineMessage message = (DeadlineMessage)Mockito.mock(DeadlineMessage.class);
        this.test(builder -> builder.deadlineIdAttribute("this-is-a-stupidly-long-attribute-name"), spanFactory -> spanFactory.createExecuteSpan("myDeadline", "myDeadlineId", message), this.expectedSpan("DeadlineManager.executeDeadline(myDeadline)", TestSpanFactory.TestSpanType.HANDLER_LINK).withMessage((Message<?>)message).expectAttribute("this-is-a-stupidly-long-attribute-name", "myDeadlineId"));
    }

    @Test
    void propagateContext() {
        DeadlineMessage message = (DeadlineMessage)Mockito.mock(DeadlineMessage.class);
        this.testContextPropagation(message, DeadlineManagerSpanFactory::propagateContext);
    }

    @Override
    protected DefaultDeadlineManagerSpanFactory.Builder createBuilder(SpanFactory spanFactory) {
        return DefaultDeadlineManagerSpanFactory.builder().spanFactory(spanFactory);
    }

    @Override
    protected DeadlineManagerSpanFactory createFactoryBasedOnBuilder(DefaultDeadlineManagerSpanFactory.Builder builder) {
        return builder.build();
    }
}

