/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.annotation;

import java.util.concurrent.atomic.AtomicInteger;
import org.axonframework.deadline.GenericDeadlineMessage;
import org.axonframework.deadline.annotation.DeadlineHandler;
import org.axonframework.eventhandling.AnnotationEventHandlerAdapter;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DeadlineMethodMessageHandlerDefinitionTest {
    private AnnotationEventHandlerAdapter handlerAdapter;
    private Listener listener;

    DeadlineMethodMessageHandlerDefinitionTest() {
    }

    @BeforeEach
    void setUp() {
        this.listener = new Listener();
        this.handlerAdapter = new AnnotationEventHandlerAdapter((Object)this.listener);
    }

    @Test
    void deadlineManagerIsEvaluatedBeforeGenericEventHandler() throws Exception {
        this.handlerAdapter.handle((EventMessage)new GenericDeadlineMessage("someDeadline", (Object)"test"));
        MatcherAssert.assertThat((String)"Deadline handler is invoked", (this.listener.deadlineCounter.get() == 1 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"Event handler was not invoked", (this.listener.eventCounter.get() == 0 ? 1 : 0) != 0);
    }

    @Test
    void namedDeadlineManagerIsEvaluatedBeforeGenericOne() throws Exception {
        this.handlerAdapter.handle((EventMessage)new GenericDeadlineMessage("specificDeadline", (Object)"test"));
        MatcherAssert.assertThat((String)"Generic Deadline handler was not invoked", (this.listener.deadlineCounter.get() == 0 ? 1 : 0) != 0);
        MatcherAssert.assertThat((String)"Specific Deadline handler was invoked", (this.listener.specificDeadlineCounter.get() == 1 ? 1 : 0) != 0);
    }

    private class Listener {
        private AtomicInteger eventCounter = new AtomicInteger();
        private AtomicInteger deadlineCounter = new AtomicInteger();
        private AtomicInteger specificDeadlineCounter = new AtomicInteger();

        private Listener() {
        }

        @EventHandler
        public void handleA(String event) {
            this.eventCounter.incrementAndGet();
        }

        @DeadlineHandler
        public void handleDeadline(String event) {
            this.deadlineCounter.incrementAndGet();
        }

        @DeadlineHandler(deadlineName="specificDeadline")
        public void handleSpecificDeadline(String event) {
            this.specificDeadlineCounter.incrementAndGet();
        }
    }
}

