/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.dbscheduler;

import com.github.kagkarlsson.scheduler.Scheduler;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.dbscheduler.DbSchedulerDeadlineManager;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DbSchedulerDeadlineManagerBuilderTest {
    private DbSchedulerDeadlineManager.Builder builder;
    private final Scheduler scheduler = (Scheduler)Mockito.mock(Scheduler.class);
    private final TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
    private final ScopeAwareProvider scopeAwareProvider = (ScopeAwareProvider)Mockito.mock(ScopeAwareProvider.class);

    DbSchedulerDeadlineManagerBuilderTest() {
    }

    @BeforeEach
    void newBuilder() {
        this.builder = DbSchedulerDeadlineManager.builder();
    }

    @Test
    void whenAllPropertiesAreSetCreatesManager() {
        DbSchedulerDeadlineManager manager = this.builder.scopeAwareProvider(this.scopeAwareProvider).transactionManager(this.transactionManager).scheduler(this.scheduler).serializer(TestSerializer.JACKSON.getSerializer()).build();
        Assertions.assertNotNull((Object)manager);
    }

    @Test
    void validateNeedsAllPropertiesSet() {
        this.builder.scheduler(this.scheduler).transactionManager(this.transactionManager);
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.build());
    }

    @Test
    void whenSettingSchedulerWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.scheduler(null));
    }

    @Test
    void whenSettingTransactionManagerWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.transactionManager(null));
    }

    @Test
    void whenSettingScopeAwareProviderWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.scopeAwareProvider(null));
    }
}

