/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.deadline.jobrunr;

import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.deadline.TestScopeDescriptor;
import org.axonframework.deadline.jobrunr.JobRunrDeadlineManager;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.serialization.TestSerializer;
import org.jobrunr.scheduling.JobScheduler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class JobRunrDeadlineManagerBuilderTest {
    private static final String TEST_DEADLINE_NAME = "deadline-name";
    private JobRunrDeadlineManager.Builder builder;
    private final JobScheduler jobScheduler = (JobScheduler)Mockito.mock(JobScheduler.class);
    private final TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
    private final ScopeAwareProvider scopeAwareProvider = (ScopeAwareProvider)Mockito.mock(ScopeAwareProvider.class);

    JobRunrDeadlineManagerBuilderTest() {
    }

    @BeforeEach
    void newBuilder() {
        this.builder = JobRunrDeadlineManager.builder();
    }

    @Test
    void whenAllPropertiesAreSetCreatesManager() {
        JobRunrDeadlineManager manager = this.builder.scopeAwareProvider(this.scopeAwareProvider).transactionManager(this.transactionManager).jobScheduler(this.jobScheduler).serializer(TestSerializer.JACKSON.getSerializer()).build();
        Assertions.assertNotNull((Object)manager);
    }

    @Test
    void validateNeedsAllPropertiesSet() {
        this.builder.jobScheduler(this.jobScheduler).transactionManager(this.transactionManager);
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.build());
    }

    @Test
    void whenSettingSchedulerWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.jobScheduler(null));
    }

    @Test
    void whenSettingTransactionManagerWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.transactionManager(null));
    }

    @Test
    void whenSettingScopeAwareProviderWithNullThrowError() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> this.builder.scopeAwareProvider(null));
    }

    @Test
    void cancelAllNotImplemented() {
        JobRunrDeadlineManager manager = this.builder.scopeAwareProvider(this.scopeAwareProvider).transactionManager(this.transactionManager).jobScheduler(this.jobScheduler).serializer(TestSerializer.JACKSON.getSerializer()).build();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> manager.cancelAll(TEST_DEADLINE_NAME));
    }

    @Test
    void cancelAllWithinScopeNotImplemented() {
        JobRunrDeadlineManager manager = this.builder.scopeAwareProvider(this.scopeAwareProvider).transactionManager(this.transactionManager).jobScheduler(this.jobScheduler).serializer(TestSerializer.JACKSON.getSerializer()).build();
        TestScopeDescriptor descriptor = new TestScopeDescriptor("aggregate-type", "aggregate-identifier");
        Assertions.assertThrows(UnsupportedOperationException.class, () -> manager.cancelAllWithinScope(TEST_DEADLINE_NAME, descriptor));
    }
}

