/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.AbstractEventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.monitoring.MessageMonitor;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AbstractEventBusTest {
    private UnitOfWork<?> unitOfWork;
    private StubPublishingEventBus testSubject;

    AbstractEventBusTest() {
    }

    @BeforeEach
    void setUp() {
        this.unitOfWork = (UnitOfWork)Mockito.spy((Object)new DefaultUnitOfWork(null));
        this.unitOfWork.start();
        this.testSubject = (StubPublishingEventBus)((Object)Mockito.spy((Object)((Object)StubPublishingEventBus.builder().build())));
    }

    @AfterEach
    void tearDown() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
    }

    @Test
    void consumersRegisteredWithUnitOfWorkWhenFirstEventIsPublished() {
        EventMessage<Object> event = AbstractEventBusTest.newEvent();
        this.testSubject.publish(new EventMessage[]{event});
        ((UnitOfWork)Mockito.verify(this.unitOfWork)).onPrepareCommit((Consumer)Mockito.any());
        ((UnitOfWork)Mockito.verify(this.unitOfWork)).onCommit((Consumer)Mockito.any());
        ((UnitOfWork)Mockito.verify(this.unitOfWork, (VerificationMode)Mockito.times((int)2))).afterCommit((Consumer)Mockito.any());
        Assertions.assertEquals(Collections.emptyList(), (Object)this.testSubject.committedEvents);
        this.unitOfWork.commit();
        Assertions.assertEquals(Collections.singletonList(event), (Object)this.testSubject.committedEvents);
    }

    @Test
    void noMoreConsumersRegisteredWithUnitOfWorkWhenSecondEventIsPublished() {
        EventMessage<Object> event = AbstractEventBusTest.newEvent();
        this.testSubject.publish(new EventMessage[]{event});
        ((UnitOfWork)Mockito.verify(this.unitOfWork)).onPrepareCommit((Consumer)Mockito.any());
        ((UnitOfWork)Mockito.verify(this.unitOfWork)).onCommit((Consumer)Mockito.any());
        ((UnitOfWork)Mockito.verify(this.unitOfWork, (VerificationMode)Mockito.times((int)2))).afterCommit((Consumer)Mockito.any());
        Mockito.reset((Object[])new UnitOfWork[]{this.unitOfWork});
        this.testSubject.publish(new EventMessage[]{event});
        ((UnitOfWork)Mockito.verify(this.unitOfWork, (VerificationMode)Mockito.never())).onPrepareCommit((Consumer)Mockito.any());
        ((UnitOfWork)Mockito.verify(this.unitOfWork, (VerificationMode)Mockito.never())).onCommit((Consumer)Mockito.any());
        ((UnitOfWork)Mockito.verify(this.unitOfWork)).afterCommit((Consumer)Mockito.any());
        this.unitOfWork.commit();
        List actual = this.testSubject.committedEvents;
        Assertions.assertEquals(Arrays.asList(event, event), (Object)actual);
    }

    @Test
    void commitOnUnitOfWork() {
        EventMessage<Object> event = AbstractEventBusTest.newEvent();
        this.testSubject.publish(new EventMessage[]{event});
        this.unitOfWork.commit();
        Assertions.assertEquals(Collections.singletonList(event), (Object)this.testSubject.committedEvents);
    }

    @Test
    void publicationOrder() {
        EventMessage<Object> eventA = AbstractEventBusTest.newEvent();
        EventMessage<Object> eventB = AbstractEventBusTest.newEvent();
        this.testSubject.publish(new EventMessage[]{eventA});
        this.testSubject.publish(new EventMessage[]{eventB});
        this.unitOfWork.commit();
        Assertions.assertEquals(Arrays.asList(eventA, eventB), (Object)this.testSubject.committedEvents);
    }

    @Test
    void publicationWithNestedUow() {
        this.testSubject.publish(new EventMessage[]{AbstractEventBusTest.numberedEvent(5)});
        this.unitOfWork.commit();
        Assertions.assertEquals(Arrays.asList(AbstractEventBusTest.numberedEvent(5), AbstractEventBusTest.numberedEvent(4), AbstractEventBusTest.numberedEvent(3), AbstractEventBusTest.numberedEvent(2), AbstractEventBusTest.numberedEvent(1), AbstractEventBusTest.numberedEvent(0)), (Object)this.testSubject.committedEvents);
        ((StubPublishingEventBus)((Object)Mockito.verify((Object)((Object)this.testSubject), (VerificationMode)Mockito.times((int)6)))).prepareCommit((List)Mockito.any());
        ((StubPublishingEventBus)((Object)Mockito.verify((Object)((Object)this.testSubject), (VerificationMode)Mockito.times((int)6)))).commit((List)Mockito.any());
        ((StubPublishingEventBus)((Object)Mockito.verify((Object)((Object)this.testSubject), (VerificationMode)Mockito.times((int)6)))).afterCommit((List)Mockito.any());
        ((UnitOfWork)Mockito.verify(this.unitOfWork, (VerificationMode)Mockito.times((int)1))).onPrepareCommit((Consumer)Mockito.any());
        ((UnitOfWork)Mockito.verify(this.unitOfWork, (VerificationMode)Mockito.times((int)6))).onCommit((Consumer)Mockito.any());
    }

    @Test
    void publicationForbiddenDuringUowCommitPhase() {
        StubPublishingEventBus.builder().publicationPhase(UnitOfWork.Phase.COMMIT).startNewUowBeforePublishing(false).build().publish(new EventMessage[]{AbstractEventBusTest.numberedEvent(5)});
        Assertions.assertThrows(IllegalStateException.class, () -> this.unitOfWork.commit());
    }

    @Test
    void publicationForbiddenDuringRootUowCommitPhase() {
        this.testSubject = (StubPublishingEventBus)((Object)Mockito.spy((Object)((Object)StubPublishingEventBus.builder().publicationPhase(UnitOfWork.Phase.COMMIT).build())));
        this.testSubject.publish(new EventMessage[]{AbstractEventBusTest.numberedEvent(1)});
        Assertions.assertThrows(IllegalStateException.class, () -> this.unitOfWork.commit());
    }

    @Test
    void messageMonitorRecordsIngestionAndPublication_InUnitOfWork() {
        MessageMonitor mockMonitor = (MessageMonitor)Mockito.mock(MessageMonitor.class);
        MessageMonitor.MonitorCallback mockMonitorCallback = (MessageMonitor.MonitorCallback)Mockito.mock(MessageMonitor.MonitorCallback.class);
        Mockito.when((Object)mockMonitor.onMessageIngested((Message)Mockito.any())).thenReturn((Object)mockMonitorCallback);
        this.testSubject = (StubPublishingEventBus)((Object)Mockito.spy((Object)((Object)((StubPublishingEventBus.Builder)StubPublishingEventBus.builder().messageMonitor(mockMonitor)).build())));
        this.testSubject.publish(new EventMessage[]{GenericEventMessage.asEventMessage((Object)"test1"), GenericEventMessage.asEventMessage((Object)"test2")});
        ((MessageMonitor)Mockito.verify((Object)mockMonitor, (VerificationMode)Mockito.times((int)2))).onMessageIngested((Message)Mockito.any());
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)mockMonitorCallback, (VerificationMode)Mockito.never())).reportSuccess();
        this.unitOfWork.commit();
        ((MessageMonitor.MonitorCallback)Mockito.verify((Object)mockMonitorCallback, (VerificationMode)Mockito.times((int)2))).reportSuccess();
    }

    @Test
    void dispatchInterceptor() {
        MessageDispatchInterceptor dispatchInterceptorMock = (MessageDispatchInterceptor)Mockito.mock(MessageDispatchInterceptor.class);
        String key = "additional";
        String value = "metaData";
        Mockito.when((Object)dispatchInterceptorMock.handle(Mockito.anyList())).thenAnswer(invocation -> {
            List eventMessages = (List)invocation.getArguments()[0];
            return (index, message) -> {
                if (((EventMessage)eventMessages.get((int)index)).getMetaData().containsKey((Object)key)) {
                    throw new AssertionError((Object)"MessageProcessor is asked to process the same event message twice");
                }
                return ((EventMessage)eventMessages.get((int)index)).andMetaData(Collections.singletonMap(key, value));
            };
        });
        this.testSubject.registerDispatchInterceptor(dispatchInterceptorMock);
        this.testSubject.publish(new EventMessage[]{AbstractEventBusTest.newEvent(), AbstractEventBusTest.newEvent()});
        Mockito.verifyNoInteractions((Object[])new Object[]{dispatchInterceptorMock});
        this.unitOfWork.commit();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(List.class);
        ((MessageDispatchInterceptor)Mockito.verify((Object)dispatchInterceptorMock)).handle((List)argumentCaptor.capture());
        Assertions.assertEquals((int)1, (int)argumentCaptor.getAllValues().size());
        Assertions.assertEquals((int)2, (int)((List)argumentCaptor.getValue()).size());
        Assertions.assertEquals((Object)value, (Object)((EventMessage)((List)argumentCaptor.getValue()).get(0)).getMetaData().get((Object)key));
    }

    private static EventMessage<Object> newEvent() {
        return new GenericEventMessage(new Object());
    }

    private static EventMessage<Integer> numberedEvent(int number) {
        return new StubNumberedEvent(number);
    }

    private static class StubNumberedEvent
    extends GenericEventMessage<Integer> {
        StubNumberedEvent(Integer payload) {
            super((Object)payload);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            StubNumberedEvent that = (StubNumberedEvent)((Object)o);
            return Objects.equals(this.getPayload(), that.getPayload());
        }

        public int hashCode() {
            return Objects.hash(this.getPayload());
        }

        public String toString() {
            return "StubNumberedEvent{" + this.getPayload() + "}";
        }
    }

    private static class StubPublishingEventBus
    extends AbstractEventBus {
        private final List<EventMessage<?>> committedEvents = new ArrayList();
        private final UnitOfWork.Phase publicationPhase;
        private final boolean startNewUowBeforePublishing;

        private StubPublishingEventBus(Builder builder) {
            super((AbstractEventBus.Builder)builder);
            this.publicationPhase = builder.publicationPhase;
            this.startNewUowBeforePublishing = builder.startNewUowBeforePublishing;
        }

        private static Builder builder() {
            return new Builder();
        }

        protected void prepareCommit(List<? extends EventMessage<?>> events) {
            if (this.publicationPhase == UnitOfWork.Phase.PREPARE_COMMIT) {
                this.onEvents(events);
            }
        }

        protected void commit(List<? extends EventMessage<?>> events) {
            if (this.publicationPhase == UnitOfWork.Phase.COMMIT) {
                this.onEvents(events);
            }
        }

        protected void afterCommit(List<? extends EventMessage<?>> events) {
            if (this.publicationPhase == UnitOfWork.Phase.AFTER_COMMIT) {
                this.onEvents(events);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onEvents(List<? extends EventMessage<?>> events) {
            int number;
            Object payload = events.get(0).getPayload();
            if (payload instanceof Integer && (number = ((Integer)payload).intValue()) > 0) {
                EventMessage nextEvent = AbstractEventBusTest.numberedEvent(number - 1);
                if (this.startNewUowBeforePublishing) {
                    DefaultUnitOfWork nestedUnitOfWork = DefaultUnitOfWork.startAndGet(null);
                    try {
                        this.publish(new EventMessage[]{nextEvent});
                    }
                    finally {
                        nestedUnitOfWork.commit();
                    }
                } else {
                    this.publish(new EventMessage[]{nextEvent});
                }
            }
            this.committedEvents.addAll(events);
        }

        public Registration subscribe(@Nonnull Consumer<List<? extends EventMessage<?>>> eventProcessor) {
            throw new UnsupportedOperationException();
        }

        private static class Builder
        extends AbstractEventBus.Builder {
            private UnitOfWork.Phase publicationPhase = UnitOfWork.Phase.PREPARE_COMMIT;
            private boolean startNewUowBeforePublishing = true;

            private Builder() {
            }

            private Builder publicationPhase(UnitOfWork.Phase publicationPhase) {
                this.publicationPhase = publicationPhase;
                return this;
            }

            public Builder messageMonitor(@Nonnull MessageMonitor<? super EventMessage<?>> messageMonitor) {
                super.messageMonitor(messageMonitor);
                return this;
            }

            private Builder startNewUowBeforePublishing(boolean startNewUowBeforePublishing) {
                this.startNewUowBeforePublishing = startNewUowBeforePublishing;
                return this;
            }

            private StubPublishingEventBus build() {
                return new StubPublishingEventBus(this);
            }
        }
    }
}

