/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.axonframework.eventhandling.AbstractEventProcessor;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.SimpleEventHandlerInvoker;
import org.axonframework.messaging.unitofwork.BatchingUnitOfWork;
import org.axonframework.messaging.unitofwork.RollbackConfiguration;
import org.axonframework.messaging.unitofwork.RollbackConfigurationType;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.utils.EventTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class AbstractEventProcessorTest {
    AbstractEventProcessorTest() {
    }

    @Test
    void expectCallbackForAllMessages() throws Exception {
        List<DomainEventMessage<?>> events = EventTestUtils.createEvents(2);
        final HashSet pending = new HashSet(events);
        MessageMonitor messageMonitor = message -> new MessageMonitor.MonitorCallback((EventMessage)message){
            final /* synthetic */ EventMessage val$message;
            {
                this.val$message = eventMessage;
            }

            public void reportSuccess() {
                if (!pending.contains(this.val$message)) {
                    Assertions.fail((String)("Message was presented to monitor twice: " + this.val$message));
                }
                pending.remove(this.val$message);
            }

            public void reportFailure(Throwable cause) {
                Assertions.fail((String)"Test expects 'reportSuccess' to be called");
            }

            public void reportIgnored() {
                Assertions.fail((String)"Test expects 'reportSuccess' to be called");
            }
        };
        EventMessageHandler mockHandler = (EventMessageHandler)Mockito.mock(EventMessageHandler.class);
        SimpleEventHandlerInvoker eventHandlerInvoker = SimpleEventHandlerInvoker.builder().eventHandlers(new Object[]{mockHandler}).build();
        TestEventProcessor testSubject = ((TestEventProcessor.Builder)TestEventProcessor.builder().name("test").eventHandlerInvoker((EventHandlerInvoker)eventHandlerInvoker).messageMonitor(messageMonitor)).build();
        testSubject.registerHandlerInterceptor((unitOfWork, interceptorChain) -> {
            unitOfWork.transformMessage(m -> EventTestUtils.createEvent());
            return interceptorChain.proceed();
        });
        testSubject.processInBatchingUnitOfWork(events);
        Assertions.assertTrue((boolean)pending.isEmpty(), (String)"Not all events were presented to monitor");
    }

    private static class TestEventProcessor
    extends AbstractEventProcessor {
        private TestEventProcessor(Builder builder) {
            super((AbstractEventProcessor.Builder)builder);
        }

        private static Builder builder() {
            return new Builder();
        }

        public void start() {
        }

        public void shutDown() {
        }

        public boolean isRunning() {
            return true;
        }

        public boolean isError() {
            return false;
        }

        void processInBatchingUnitOfWork(List<? extends EventMessage<?>> eventMessages) throws Exception {
            this.processInUnitOfWork(eventMessages, (UnitOfWork)new BatchingUnitOfWork(eventMessages));
        }

        private static class Builder
        extends AbstractEventProcessor.Builder {
            public Builder() {
                super.rollbackConfiguration((RollbackConfiguration)RollbackConfigurationType.ANY_THROWABLE);
            }

            public Builder name(@Nonnull String name) {
                super.name(name);
                return this;
            }

            public Builder eventHandlerInvoker(@Nonnull EventHandlerInvoker eventHandlerInvoker) {
                super.eventHandlerInvoker(eventHandlerInvoker);
                return this;
            }

            public Builder messageMonitor(@Nonnull MessageMonitor<? super EventMessage<?>> messageMonitor) {
                super.messageMonitor(messageMonitor);
                return this;
            }

            private TestEventProcessor build() {
                return new TestEventProcessor(this);
            }
        }
    }
}

