/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.axonframework.common.AxonException;
import org.axonframework.eventhandling.AllowReplay;
import org.axonframework.eventhandling.AnnotationEventHandlerAdapter;
import org.axonframework.eventhandling.DisallowReplay;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.ResetHandler;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.MetaDataValue;
import org.axonframework.messaging.annotation.MultiParameterResolverFactory;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.annotation.SimpleResourceParameterResolverFactory;
import org.axonframework.messaging.interceptors.ExceptionHandler;
import org.axonframework.messaging.interceptors.MessageHandlerInterceptor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AnnotationEventHandlerAdapterTest {
    private SomeHandler annotatedEventListener;
    private ParameterResolverFactory parameterResolverFactory;
    private AnnotationEventHandlerAdapter testSubject;

    AnnotationEventHandlerAdapterTest() {
    }

    @BeforeEach
    void setUp() {
        this.annotatedEventListener = new SomeHandler();
        this.parameterResolverFactory = MultiParameterResolverFactory.ordered((ParameterResolverFactory[])new ParameterResolverFactory[]{ClasspathParameterResolverFactory.forClass(this.getClass()), new SimpleResourceParameterResolverFactory(Collections.singletonList(new SomeResource()))});
        this.testSubject = new AnnotationEventHandlerAdapter((Object)this.annotatedEventListener, this.parameterResolverFactory);
    }

    @Test
    void invokeResetHandler() {
        this.testSubject.prepareReset();
        Assertions.assertTrue((boolean)this.annotatedEventListener.invocations.contains("reset"));
    }

    @Test
    void invokeResetHandlerWithResetContext() {
        this.testSubject.prepareReset((Object)"resetContext");
        Assertions.assertTrue((boolean)this.annotatedEventListener.invocations.contains("resetWithContext"));
    }

    @Test
    void handlerInterceptors() throws Exception {
        SomeInterceptingHandler annotatedEventListener = new SomeInterceptingHandler();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)annotatedEventListener, this.parameterResolverFactory);
        this.testSubject.handle(GenericEventMessage.asEventMessage((Object)"count"));
        Assertions.assertEquals((long)3L, (long)annotatedEventListener.invocations.stream().filter("count"::equals).count());
    }

    @Test
    void wrapExceptionInResultInterceptor() {
        EventMessage testEventMessage = GenericEventMessage.asEventMessage((Object)"testing").andMetaData((Map)MetaData.with((String)"key", (Object)"value"));
        SomeExceptionHandler annotatedEventListener = new SomeExceptionHandler();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)annotatedEventListener, this.parameterResolverFactory);
        try {
            this.testSubject.handle(testEventMessage);
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assertions.assertEquals(RuntimeException.class, e.getClass());
            Assertions.assertEquals(IllegalArgumentException.class, e.getCause().getClass());
            Assertions.assertEquals((Object)"testing", (Object)e.getCause().getMessage());
            Assertions.assertEquals((Object)"value", (Object)e.getMessage());
        }
    }

    @Test
    void mismatchingExceptionTypeFromHandlerIgnored() {
        EventMessage testEventMessage = GenericEventMessage.asEventMessage((Object)"testing").andMetaData((Map)MetaData.with((String)"key", (Object)"value"));
        SomeMismatchingExceptionHandler annotatedEventListener = new SomeMismatchingExceptionHandler();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)annotatedEventListener, this.parameterResolverFactory);
        try {
            this.testSubject.handle(testEventMessage);
            Assertions.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assertions.assertEquals(IllegalArgumentException.class, e.getClass());
            Assertions.assertEquals((Object)"testing", (Object)e.getMessage());
        }
    }

    @Test
    void canHandleTypeDoesNotReturnResetHandlers() {
        SomeResetHandlerWithContext annotatedEventListener = new SomeResetHandlerWithContext();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)annotatedEventListener, this.parameterResolverFactory);
        Assertions.assertTrue((boolean)this.testSubject.canHandleType(Long.class));
        Assertions.assertFalse((boolean)this.testSubject.canHandleType(String.class));
        Assertions.assertFalse((boolean)this.testSubject.canHandleType(Integer.class));
    }

    @Test
    void replayNotSupportedOnSingleHandler() {
        SingleReplayBlockingHandler handler = new SingleReplayBlockingHandler();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)handler, this.parameterResolverFactory);
        Assertions.assertTrue((boolean)this.testSubject.supportsReset());
    }

    @Test
    void replayNotSupportedOnClassLevel() {
        ReplayBlockedOnClassLevelHandler handler = new ReplayBlockedOnClassLevelHandler();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)handler, this.parameterResolverFactory);
        Assertions.assertFalse((boolean)this.testSubject.supportsReset());
    }

    @Test
    void replayNotSupportedOnClassLevelWithHandlerLevelOverride() {
        ReplayBlockedOnClassLevelWithReplayCapableHandler handler = new ReplayBlockedOnClassLevelWithReplayCapableHandler();
        this.testSubject = new AnnotationEventHandlerAdapter((Object)handler, this.parameterResolverFactory);
        Assertions.assertTrue((boolean)this.testSubject.supportsReset());
    }

    private static class SomeResource {
        private SomeResource() {
        }
    }

    @DisallowReplay
    public static class ReplayBlockedOnClassLevelWithReplayCapableHandler {
        @EventHandler
        public void handle(Long event) {
        }

        @AllowReplay
        @EventHandler
        public void handle(String event) {
        }
    }

    @DisallowReplay
    public static class ReplayBlockedOnClassLevelHandler {
        @EventHandler
        public void handle(Long event) {
        }

        @EventHandler
        public void handle(String event) {
        }
    }

    public static class SingleReplayBlockingHandler {
        @EventHandler
        public void handle(Long event) {
        }

        @DisallowReplay
        @EventHandler
        public void handle(String event) {
        }
    }

    public static class SomeResetHandlerWithContext {
        @EventHandler
        public void handle(Long event) {
        }

        @ResetHandler
        public void reset() {
        }

        @ResetHandler
        public void resetWithContext(String resetContext, SomeResource someResource) {
        }
    }

    public static class SomeInterceptingHandler
    extends SomeHandler {
        @MessageHandlerInterceptor
        public void intercept(String event, InterceptorChain chain) throws Exception {
            this.invocations.add(event);
            chain.proceed();
        }

        @MessageHandlerInterceptor
        public void intercept(Object any) {
            this.invocations.add(any.toString());
        }
    }

    private static class SomeMismatchingExceptionHandler {
        private SomeMismatchingExceptionHandler() {
        }

        @EventHandler
        public void throwException(String msg) {
            throw new IllegalArgumentException(msg);
        }

        @EventHandler
        public void handleNormally(Long value) {
        }

        @ExceptionHandler
        public void handle(@MetaDataValue(value="key", required=true) String value, AxonException e) {
            throw new RuntimeException(value, (Throwable)e);
        }

        @ExceptionHandler(resultType=NoSuchMethodException.class)
        public void handle(Exception e) {
            throw new RuntimeException("This should not have been invoked", e);
        }
    }

    private static class SomeExceptionHandler {
        private SomeExceptionHandler() {
        }

        @EventHandler
        public void throwException(String msg) {
            throw new IllegalArgumentException(msg);
        }

        @EventHandler
        public void handleNormally(Long value) {
        }

        @ExceptionHandler(resultType=IllegalArgumentException.class)
        public void handle(@MetaDataValue(value="key", required=true) String value, Exception e) {
            throw new RuntimeException(value, e);
        }
    }

    private static class SomeHandler {
        final List<String> invocations = new ArrayList<String>();

        private SomeHandler() {
        }

        @EventHandler
        public void handle(String event) {
            this.invocations.add(event);
        }

        @ResetHandler
        public void doReset() {
            this.invocations.add("reset");
        }

        @ResetHandler
        public void doResetWithContext(String resetContext, SomeResource someResource) {
            this.invocations.add("resetWithContext");
        }
    }
}

