/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.List;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.eventhandling.ConcludesBatch;
import org.axonframework.eventhandling.ConcludesBatchParameterResolverFactory;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.BatchingUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.utils.EventTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ConcludesBatchParameterResolverFactoryTest {
    private ConcludesBatchParameterResolverFactory subject = new ConcludesBatchParameterResolverFactory();

    ConcludesBatchParameterResolverFactoryTest() {
    }

    @Test
    void createInstance() throws Exception {
        Method method = this.getClass().getDeclaredMethod("handle", String.class, Boolean.class);
        Assertions.assertSame((Object)this.subject.getResolver(), (Object)this.subject.createInstance((Executable)method, method.getParameters(), 1));
        method = this.getClass().getDeclaredMethod("handlePrimitive", String.class, Boolean.TYPE);
        Assertions.assertSame((Object)this.subject.getResolver(), (Object)this.subject.createInstance((Executable)method, method.getParameters(), 1));
    }

    @Test
    void onlyMatchesEventMessages() {
        Assertions.assertTrue((boolean)this.subject.matches((Message)GenericEventMessage.asEventMessage((Object)"testEvent")));
        Assertions.assertFalse((boolean)this.subject.matches((Message)new GenericCommandMessage((Object)"testCommand")));
    }

    @Test
    void resolvesToTrueWithoutUnitOfWork() {
        Assertions.assertTrue((boolean)this.subject.resolveParameterValue((Message)GenericEventMessage.asEventMessage((Object)"testEvent")));
    }

    @Test
    void resolvesToTrueWithRegularUnitOfWork() {
        EventMessage event = GenericEventMessage.asEventMessage((Object)"testEvent");
        DefaultUnitOfWork.startAndGet((Message)event).execute(() -> Assertions.assertTrue((boolean)this.subject.resolveParameterValue((Message)event)));
    }

    @Test
    void resolvesToFalseWithBatchingUnitOfWorkIfMessageIsNotLast() {
        List<DomainEventMessage<?>> events = EventTestUtils.createEvents(5);
        new BatchingUnitOfWork(events).execute(() -> Assertions.assertFalse((boolean)this.subject.resolveParameterValue((Message)events.get(0))));
    }

    @Test
    void resolvesToFalseWithBatchingUnitOfWorkIfMessageIsLast() {
        List<DomainEventMessage<?>> events = EventTestUtils.createEvents(5);
        new BatchingUnitOfWork(events).execute(() -> Assertions.assertTrue((boolean)this.subject.resolveParameterValue((Message)events.get(4))));
    }

    private void handle(String eventPayload, @ConcludesBatch Boolean concludesBatch) {
    }

    private void handlePrimitive(String eventPayload, @ConcludesBatch boolean concludesBatch) {
    }
}

