/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import org.axonframework.eventhandling.AddedTrackerStatus;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.FakeEventTrackerStatus;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class EventTrackerStatusTest {
    private static final boolean DO_NOT_VALIDATE_POSITIONS = false;
    private static final boolean VALIDATE_POSITIONS = true;
    private FakeEventTrackerStatus thisStatus;
    private FakeEventTrackerStatus thatStatus;

    EventTrackerStatusTest() {
    }

    @BeforeEach
    void setUp() {
        this.thisStatus = new FakeEventTrackerStatus();
        this.thatStatus = new FakeEventTrackerStatus();
    }

    @Test
    void isDifferentReturnsFalseForIdenticalObjects() {
        Assertions.assertFalse((boolean)this.thisStatus.isDifferent(this.thisStatus, false));
        Assertions.assertFalse((boolean)this.thisStatus.isDifferent(this.thisStatus));
    }

    @Test
    void isDifferentReturnsTrueForDifferentEventTrackerStatusImplementations() {
        AddedTrackerStatus otherStatus = new AddedTrackerStatus((EventTrackerStatus)this.thatStatus);
        Assertions.assertTrue((boolean)this.thisStatus.isDifferent((EventTrackerStatus)otherStatus, false));
        Assertions.assertTrue((boolean)this.thisStatus.isDifferent((EventTrackerStatus)otherStatus));
    }

    @Test
    void isDifferentReturnsFalseForSimilarStatusObjects() {
        Assertions.assertFalse((boolean)this.thisStatus.isDifferent(this.thatStatus, false));
        Assertions.assertFalse((boolean)this.thisStatus.isDifferent(this.thatStatus, true));
    }

    @Test
    void isDifferentReturnsFalseForSimilarStatusObjectsWhenDisregardingPositions() {
        Assertions.assertFalse((boolean)this.thisStatus.isDifferent(this.thatStatus, false));
        Assertions.assertFalse((boolean)this.thisStatus.isDifferent(this.thatStatus, true));
        this.thisStatus.setMerging(true);
        this.thatStatus.setMerging(false);
        Assertions.assertTrue((boolean)this.thisStatus.isDifferent(this.thatStatus, false));
        Assertions.assertTrue((boolean)this.thisStatus.isDifferent(this.thatStatus, true));
        this.thisStatus.setMerging(false);
        this.thisStatus.setCurrentPosition(10L);
        this.thatStatus.setCurrentPosition(42L);
        Assertions.assertFalse((boolean)this.thisStatus.isDifferent(this.thatStatus, false));
        Assertions.assertTrue((boolean)this.thisStatus.isDifferent(this.thatStatus, true));
    }

    @Test
    void matchStates() {
        Assertions.assertTrue((boolean)this.thisStatus.matchStates(this.thatStatus));
        this.thisStatus.setSegment(Segment.ROOT_SEGMENT);
        this.thisStatus.setTrackingToken((TrackingToken)new GlobalSequenceTrackingToken(0L));
        this.thisStatus.setCaughtUp(true);
        this.thisStatus.setReplaying(true);
        this.thisStatus.setMerging(true);
        this.thisStatus.setErrorState(true);
        this.thisStatus.setError(new IllegalArgumentException("some-exception"));
        Assertions.assertFalse((boolean)this.thisStatus.matchStates(this.thatStatus));
        this.thatStatus.setSegment(Segment.ROOT_SEGMENT);
        this.thatStatus.setTrackingToken((TrackingToken)new GlobalSequenceTrackingToken(0L));
        this.thatStatus.setCaughtUp(true);
        this.thatStatus.setReplaying(true);
        this.thatStatus.setMerging(true);
        this.thatStatus.setErrorState(true);
        this.thatStatus.setError(new IllegalArgumentException("some-exception"));
        Assertions.assertTrue((boolean)this.thisStatus.matchStates(this.thatStatus));
    }

    @Test
    void matchPositions() {
        Assertions.assertTrue((boolean)this.thisStatus.matchPositions(this.thatStatus));
        this.thisStatus.setCurrentPosition(10L);
        this.thisStatus.setResetPosition(42L);
        this.thisStatus.setMergeCompletedPosition(1337L);
        Assertions.assertFalse((boolean)this.thisStatus.matchPositions(this.thatStatus));
        this.thatStatus.setCurrentPosition(10L);
        this.thatStatus.setResetPosition(42L);
        this.thatStatus.setMergeCompletedPosition(1337L);
        Assertions.assertTrue((boolean)this.thisStatus.matchPositions(this.thatStatus));
    }

    @Test
    void trackerAdded() {
        Assertions.assertFalse((boolean)this.thisStatus.trackerAdded());
    }

    @Test
    void trackerRemoved() {
        Assertions.assertFalse((boolean)this.thisStatus.trackerRemoved());
    }
}

