/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.MergedTrackingToken;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.WrappedToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class MergedTrackingTokenTest {
    MergedTrackingTokenTest() {
    }

    @Test
    void mergedTokenCoversOriginal() {
        MergedTrackingToken testSubject = new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(3));
        Assertions.assertTrue((boolean)testSubject.covers((TrackingToken)this.token(1)));
        Assertions.assertFalse((boolean)testSubject.covers((TrackingToken)this.token(2)));
        Assertions.assertFalse((boolean)testSubject.covers((TrackingToken)this.token(3)));
    }

    @Test
    void upperBound() {
        MergedTrackingToken testSubject = new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(3));
        Assertions.assertEquals((Object)new MergedTrackingToken((TrackingToken)this.token(2), (TrackingToken)this.token(3)), (Object)testSubject.upperBound((TrackingToken)this.token(2)));
        Assertions.assertEquals((Object)this.token(3), (Object)testSubject.upperBound((TrackingToken)this.token(3)));
    }

    @Test
    void lowerBound() {
        MergedTrackingToken testSubject = new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(3));
        Assertions.assertEquals((Object)new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(2)), (Object)testSubject.lowerBound((TrackingToken)this.token(2)));
        Assertions.assertEquals((Object)this.token(1), (Object)testSubject.lowerBound((TrackingToken)this.token(1)));
    }

    @Test
    void unwrapToLowerBound() {
        Assertions.assertEquals((Object)this.token(1), (Object)new MergedTrackingToken((TrackingToken)new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(5)), (TrackingToken)this.token(3)).lowerBound());
        Assertions.assertEquals((Object)this.token(1), (Object)new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)new MergedTrackingToken((TrackingToken)this.token(5), (TrackingToken)this.token(3))).lowerBound());
    }

    @Test
    void upperBound_NestedTokens() {
        MergedTrackingToken testSubject = new MergedTrackingToken((TrackingToken)new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(3)), (TrackingToken)this.token(5));
        Assertions.assertEquals((Object)new MergedTrackingToken((TrackingToken)this.token(4), (TrackingToken)this.token(5)), (Object)testSubject.upperBound((TrackingToken)this.token(4)));
        Assertions.assertEquals((Object)new MergedTrackingToken((TrackingToken)new MergedTrackingToken((TrackingToken)this.token(3), (TrackingToken)this.token(3)), (TrackingToken)this.token(5)), (Object)testSubject.upperBound((TrackingToken)this.token(3)));
        Assertions.assertEquals((Object)new MergedTrackingToken((TrackingToken)new MergedTrackingToken((TrackingToken)this.token(2), (TrackingToken)this.token(3)), (TrackingToken)this.token(5)), (Object)testSubject.upperBound((TrackingToken)this.token(2)));
    }

    @Test
    void lowerBound_NestedTokens() {
        MergedTrackingToken testSubject = new MergedTrackingToken((TrackingToken)new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(5)), (TrackingToken)this.token(3));
        Assertions.assertEquals((Object)new MergedTrackingToken((TrackingToken)new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(3)), (TrackingToken)this.token(3)), (Object)testSubject.lowerBound((TrackingToken)this.token(3)));
        Assertions.assertEquals((Object)new MergedTrackingToken((TrackingToken)new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(2)), (TrackingToken)this.token(2)), (Object)testSubject.lowerBound((TrackingToken)this.token(2)));
        Assertions.assertEquals((Object)this.token(1), (Object)testSubject.lowerBound((TrackingToken)this.token(1)));
    }

    @Test
    void advanceWithNestedReplayToken() {
        GlobalSequenceTrackingToken incomingMessage = new GlobalSequenceTrackingToken(0L);
        MergedTrackingToken currentToken = new MergedTrackingToken((TrackingToken)new ReplayToken((TrackingToken)new GlobalSequenceTrackingToken(9L), (TrackingToken)new GlobalSequenceTrackingToken(9L)), (TrackingToken)new ReplayToken((TrackingToken)new GlobalSequenceTrackingToken(9L), (TrackingToken)new GlobalSequenceTrackingToken(-1L)));
        TrackingToken advancedToken = currentToken.advancedTo((TrackingToken)incomingMessage);
        Assertions.assertTrue((boolean)(advancedToken instanceof MergedTrackingToken));
        MergedTrackingToken actual = (MergedTrackingToken)advancedToken;
        Assertions.assertTrue((boolean)(actual.lowerSegmentToken() instanceof ReplayToken));
        Assertions.assertTrue((boolean)(actual.upperSegmentToken() instanceof ReplayToken), (String)("Wrong upper segment: " + actual.upperSegmentToken()));
    }

    @Test
    void unwrapPrefersLastAdvancedToken_LowerSegmentAdvanced() {
        TrackingToken merged = new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(3)).advancedTo((TrackingToken)this.token(2));
        Assertions.assertTrue((boolean)(merged instanceof MergedTrackingToken));
        Assertions.assertEquals((Object)this.token(2), WrappedToken.unwrap((TrackingToken)merged, GlobalSequenceTrackingToken.class).orElse(null));
    }

    @Test
    void unwrapPrefersLastAdvancedToken_UpperSegmentAdvanced() {
        TrackingToken merged = new MergedTrackingToken((TrackingToken)this.token(3), (TrackingToken)this.token(1)).advancedTo((TrackingToken)this.token(2));
        Assertions.assertTrue((boolean)(merged instanceof MergedTrackingToken));
        Assertions.assertEquals((Object)this.token(2), WrappedToken.unwrap((TrackingToken)merged, GlobalSequenceTrackingToken.class).orElse(null));
    }

    @Test
    void unwrapPrefersLastAdvancedToken_NeitherSegmentAdvanced() {
        TrackingToken merged = new MergedTrackingToken((TrackingToken)this.token(3), (TrackingToken)this.token(3)).advancedTo((TrackingToken)this.token(2));
        Assertions.assertTrue((boolean)(merged instanceof MergedTrackingToken));
        Assertions.assertEquals((Object)this.token(3), WrappedToken.unwrap((TrackingToken)merged, GlobalSequenceTrackingToken.class).orElse(null));
    }

    @Test
    void unwrapPrefersLastAdvancedToken_NeitherSegmentAdvanced_OnlyLowerIsCandidate() {
        MergedTrackingToken merged = new MergedTrackingToken((TrackingToken)this.token(3), (TrackingToken)Mockito.mock(TrackingToken.class));
        Assertions.assertEquals((Object)this.token(3), merged.unwrap(GlobalSequenceTrackingToken.class).orElse(null));
    }

    @Test
    void unwrapPrefersLastAdvancedToken_NeitherSegmentAdvanced_OnlyUpperIsCandidate() {
        MergedTrackingToken merged = new MergedTrackingToken((TrackingToken)Mockito.mock(TrackingToken.class), (TrackingToken)this.token(3));
        Assertions.assertEquals((Object)this.token(3), merged.unwrap(GlobalSequenceTrackingToken.class).orElse(null));
    }

    @Test
    void positionReportsLowestSegment() {
        MergedTrackingToken merged = new MergedTrackingToken((TrackingToken)this.token(4), (TrackingToken)this.token(3));
        Assertions.assertEquals((long)3L, (long)merged.position().orElse(0L));
    }

    @Test
    void positionIsNotPresent() {
        MergedTrackingToken merged = new MergedTrackingToken((TrackingToken)Mockito.mock(TrackingToken.class), (TrackingToken)this.token(3));
        Assertions.assertFalse((boolean)merged.position().isPresent());
    }

    @Test
    void isMergeInProgress() {
        MergedTrackingToken testSubject = new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(3));
        Assertions.assertTrue((boolean)MergedTrackingToken.isMergeInProgress((TrackingToken)testSubject));
    }

    @Test
    void mergePosition() {
        MergedTrackingToken testSubject = new MergedTrackingToken((TrackingToken)new MergedTrackingToken((TrackingToken)this.token(1), (TrackingToken)this.token(3)), (TrackingToken)this.token(5));
        Assertions.assertTrue((boolean)MergedTrackingToken.mergePosition((TrackingToken)testSubject).isPresent());
        Assertions.assertEquals((long)MergedTrackingToken.mergePosition((TrackingToken)testSubject).getAsLong(), (long)5L);
    }

    @Test
    void coversWithNestedMergedNullTokens() {
        MergedTrackingToken testSubject = new MergedTrackingToken((TrackingToken)new MergedTrackingToken(null, null), null);
        Assertions.assertFalse((boolean)testSubject.covers((TrackingToken)this.token(0)));
        Assertions.assertTrue((boolean)testSubject.covers(null));
        GlobalSequenceTrackingToken advance = this.token(1);
        Assertions.assertSame((Object)advance, (Object)testSubject.advancedTo((TrackingToken)advance));
    }

    @Test
    void coversWithNullTokens() {
        MergedTrackingToken testSubject = new MergedTrackingToken(null, null);
        Assertions.assertFalse((boolean)testSubject.covers((TrackingToken)this.token(0)));
        Assertions.assertTrue((boolean)testSubject.covers(null));
        GlobalSequenceTrackingToken advance = this.token(1);
        Assertions.assertSame((Object)advance, (Object)testSubject.advancedTo((TrackingToken)advance));
    }

    private GlobalSequenceTrackingToken token(int sequence) {
        return new GlobalSequenceTrackingToken((long)sequence);
    }
}

