/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Collections;
import org.axonframework.eventhandling.ErrorContext;
import org.axonframework.eventhandling.EventProcessingException;
import org.axonframework.eventhandling.PropagatingErrorHandler;
import org.axonframework.utils.MockException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PropagatingErrorHandlerTest {
    private PropagatingErrorHandler testSubject = PropagatingErrorHandler.instance();

    PropagatingErrorHandlerTest() {
    }

    @Test
    void handleErrorRethrowsOriginalWhenError() throws Exception {
        ErrorContext context = new ErrorContext("test", (Throwable)new MockError(), Collections.emptyList());
        Assertions.assertThrows(MockError.class, () -> this.testSubject.handleError(context));
    }

    @Test
    void handleErrorRethrowsOriginalWhenException() throws Exception {
        ErrorContext context = new ErrorContext("test", (Throwable)new MockException(), Collections.emptyList());
        Assertions.assertThrows(MockException.class, () -> this.testSubject.handleError(context));
    }

    @Test
    void handleErrorWrapsOriginalWhenThrowable() throws Exception {
        ErrorContext context = new ErrorContext("test", new Throwable("Unknown"), Collections.emptyList());
        Assertions.assertThrows(EventProcessingException.class, () -> this.testSubject.handleError(context));
    }

    private static class MockError
    extends Error {
        public MockError() {
            super("Mock");
        }
    }
}

