/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.OptionalLong;
import org.axonframework.eventhandling.EventTrackerStatus;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.RemovedTrackerStatus;
import org.axonframework.eventhandling.Segment;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class RemovedTrackerStatusTest {
    RemovedTrackerStatusTest() {
    }

    @Test
    void getSegment() {
        Segment expectedSegment = Segment.ROOT_SEGMENT;
        EventTrackerStatus delegate = (EventTrackerStatus)Mockito.mock(EventTrackerStatus.class);
        Mockito.when((Object)delegate.getSegment()).thenReturn((Object)expectedSegment);
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus(delegate);
        Assertions.assertEquals((Object)expectedSegment, (Object)testSubject.getSegment());
    }

    @Test
    void isCaughtUp() {
        boolean expectedIsCaughtUp = true;
        EventTrackerStatus delegate = (EventTrackerStatus)Mockito.mock(EventTrackerStatus.class);
        Mockito.when((Object)delegate.isCaughtUp()).thenReturn((Object)expectedIsCaughtUp);
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus(delegate);
        Assertions.assertEquals((Object)expectedIsCaughtUp, (Object)testSubject.isCaughtUp());
    }

    @Test
    void isReplaying() {
        boolean expectedIsReplaying = true;
        EventTrackerStatus delegate = (EventTrackerStatus)Mockito.mock(EventTrackerStatus.class);
        Mockito.when((Object)delegate.isReplaying()).thenReturn((Object)expectedIsReplaying);
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus(delegate);
        Assertions.assertEquals((Object)expectedIsReplaying, (Object)testSubject.isReplaying());
    }

    @Test
    void isMerging() {
        boolean expectedIsMerging = true;
        EventTrackerStatus delegate = (EventTrackerStatus)Mockito.mock(EventTrackerStatus.class);
        Mockito.when((Object)delegate.isMerging()).thenReturn((Object)expectedIsMerging);
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus(delegate);
        Assertions.assertEquals((Object)expectedIsMerging, (Object)testSubject.isMerging());
    }

    @Test
    void getTrackingToken() {
        GlobalSequenceTrackingToken expectedTrackingToken = new GlobalSequenceTrackingToken(0L);
        EventTrackerStatus delegate = (EventTrackerStatus)Mockito.mock(EventTrackerStatus.class);
        Mockito.when((Object)delegate.getTrackingToken()).thenReturn((Object)expectedTrackingToken);
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus(delegate);
        Assertions.assertEquals((Object)expectedTrackingToken, (Object)testSubject.getTrackingToken());
    }

    @Test
    void isErrorState() {
        boolean expectedIsErrorState = true;
        EventTrackerStatus delegate = (EventTrackerStatus)Mockito.mock(EventTrackerStatus.class);
        Mockito.when((Object)delegate.isErrorState()).thenReturn((Object)expectedIsErrorState);
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus(delegate);
        Assertions.assertEquals((Object)expectedIsErrorState, (Object)testSubject.isErrorState());
    }

    @Test
    void getError() {
        IllegalArgumentException expectedException = new IllegalArgumentException("some-exception");
        EventTrackerStatus delegate = (EventTrackerStatus)Mockito.mock(EventTrackerStatus.class);
        Mockito.when((Object)delegate.getError()).thenReturn((Object)expectedException);
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus(delegate);
        Assertions.assertEquals((Object)expectedException, (Object)testSubject.getError());
    }

    @Test
    void getCurrentPosition() {
        long expectedCurrentPosition = 0L;
        EventTrackerStatus delegate = (EventTrackerStatus)Mockito.mock(EventTrackerStatus.class);
        Mockito.when((Object)delegate.getCurrentPosition()).thenReturn((Object)OptionalLong.of(expectedCurrentPosition));
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus(delegate);
        OptionalLong result = testSubject.getCurrentPosition();
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((long)expectedCurrentPosition, (long)result.getAsLong());
    }

    @Test
    void getResetPosition() {
        long expectedResetPosition = 0L;
        EventTrackerStatus delegate = (EventTrackerStatus)Mockito.mock(EventTrackerStatus.class);
        Mockito.when((Object)delegate.getResetPosition()).thenReturn((Object)OptionalLong.of(expectedResetPosition));
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus(delegate);
        OptionalLong result = testSubject.getResetPosition();
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((long)expectedResetPosition, (long)result.getAsLong());
    }

    @Test
    void mergeCompletedPosition() {
        long expectedMergeCompletedPosition = 0L;
        EventTrackerStatus delegate = (EventTrackerStatus)Mockito.mock(EventTrackerStatus.class);
        Mockito.when((Object)delegate.mergeCompletedPosition()).thenReturn((Object)OptionalLong.of(expectedMergeCompletedPosition));
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus(delegate);
        OptionalLong result = testSubject.mergeCompletedPosition();
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((long)expectedMergeCompletedPosition, (long)result.getAsLong());
    }

    @Test
    void trackerAdded() {
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus((EventTrackerStatus)Mockito.mock(EventTrackerStatus.class));
        Assertions.assertFalse((boolean)testSubject.trackerAdded());
    }

    @Test
    void trackerRemoved() {
        RemovedTrackerStatus testSubject = new RemovedTrackerStatus((EventTrackerStatus)Mockito.mock(EventTrackerStatus.class));
        Assertions.assertTrue((boolean)testSubject.trackerRemoved());
    }
}

