/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.ReplayToken;
import org.axonframework.eventhandling.TrackingToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ReplayTokenTest {
    private TrackingToken innerToken;

    ReplayTokenTest() {
    }

    @BeforeEach
    void setUp() {
        this.innerToken = GapAwareTrackingToken.newInstance((long)10L, Collections.singleton(9L));
    }

    @Test
    void advanceReplayTokenWithinReplaySegment() {
        ReplayToken testSubject = new ReplayToken(this.innerToken);
        TrackingToken actual = testSubject.advancedTo((TrackingToken)GapAwareTrackingToken.newInstance((long)8L, Collections.emptySet()));
        Assertions.assertTrue((boolean)(actual instanceof ReplayToken));
        Assertions.assertTrue((boolean)ReplayToken.isReplay((TrackingToken)actual));
    }

    @Test
    void regularTokenIsProvidedWhenResetBeyondCurrentPosition() {
        GlobalSequenceTrackingToken token1 = new GlobalSequenceTrackingToken(1L);
        GlobalSequenceTrackingToken token2 = new GlobalSequenceTrackingToken(2L);
        TrackingToken actual = ReplayToken.createReplayToken((TrackingToken)token1, (TrackingToken)token2);
        Assertions.assertSame((Object)token2, (Object)actual);
    }

    @Test
    void serializationDeserialization() throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        ReplayToken replayToken = new ReplayToken(this.innerToken);
        String serializedReplayToken = objectMapper.writer().writeValueAsString((Object)replayToken);
        ReplayToken deserializedReplayToken = (ReplayToken)objectMapper.readerFor(ReplayToken.class).readValue(serializedReplayToken);
        Assertions.assertEquals((Object)replayToken, (Object)deserializedReplayToken);
    }

    @Test
    void position() {
        GapAwareTrackingToken startPosition = GapAwareTrackingToken.newInstance((long)11L, Collections.singleton(9L));
        TrackingToken replayToken = ReplayToken.createReplayToken((TrackingToken)this.innerToken, (TrackingToken)startPosition);
        Assertions.assertTrue((boolean)replayToken.position().isPresent());
        Assertions.assertEquals((long)11L, (long)replayToken.position().getAsLong());
    }

    @Test
    void positionIsZeroAtReset() {
        TrackingToken replayToken = ReplayToken.createReplayToken((TrackingToken)this.innerToken);
        Assertions.assertEquals((long)0L, (long)replayToken.position().orElse(-1L));
    }

    @Test
    void getTokenAtReset() {
        ReplayToken testSubject = (ReplayToken)ReplayToken.createReplayToken((TrackingToken)this.innerToken);
        TrackingToken actual = testSubject.advancedTo((TrackingToken)GapAwareTrackingToken.newInstance((long)6L, Collections.emptySet()));
        Assertions.assertTrue((boolean)(actual instanceof ReplayToken));
        Assertions.assertEquals((Object)testSubject.getTokenAtReset(), (Object)this.innerToken);
    }

    @Test
    void createReplayTokenReturnsStartPositionIfTokenAtResetIsNull() {
        TrackingToken tokenAtReset = null;
        GlobalSequenceTrackingToken startPosition = new GlobalSequenceTrackingToken(1L);
        TrackingToken result = ReplayToken.createReplayToken(tokenAtReset, (TrackingToken)startPosition);
        Assertions.assertEquals((Object)startPosition, (Object)result);
    }

    @Test
    void createReplayTokenReturnsStartPositionIfStartPositionCoversTokenAtReset() {
        GlobalSequenceTrackingToken tokenAtReset = new GlobalSequenceTrackingToken(1L);
        GlobalSequenceTrackingToken startPosition = new GlobalSequenceTrackingToken(2L);
        TrackingToken result = ReplayToken.createReplayToken((TrackingToken)tokenAtReset, (TrackingToken)startPosition);
        Assertions.assertEquals((Object)startPosition, (Object)result);
    }

    @Test
    void createReplayTokenReturnsWrappedReplayTokenIfTokenAtResetIsReplayToken() {
        TrackingToken tokenAtReset = ReplayToken.createReplayToken((TrackingToken)new GlobalSequenceTrackingToken(1L));
        GlobalSequenceTrackingToken startPosition = new GlobalSequenceTrackingToken(2L);
        TrackingToken result = ReplayToken.createReplayToken((TrackingToken)tokenAtReset, (TrackingToken)startPosition);
        Assertions.assertEquals((Object)startPosition, (Object)result);
    }

    @Test
    void createReplayTokenReturnsReplayToken() {
        GlobalSequenceTrackingToken tokenAtReset = new GlobalSequenceTrackingToken(2L);
        GlobalSequenceTrackingToken startPosition = new GlobalSequenceTrackingToken(1L);
        TrackingToken result = ReplayToken.createReplayToken((TrackingToken)tokenAtReset, (TrackingToken)startPosition);
        Assertions.assertTrue((boolean)(result instanceof ReplayToken));
        Assertions.assertEquals((Object)tokenAtReset, (Object)((ReplayToken)result).getTokenAtReset());
        Assertions.assertEquals((Object)startPosition, (Object)((ReplayToken)result).getCurrentToken());
    }
}

