/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.async;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.async.AsynchronousEventProcessingStrategy;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.eventhandling.async.SequentialPerAggregatePolicy;
import org.axonframework.eventhandling.async.SequentialPolicy;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.utils.EventTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AsynchronousEventProcessingStrategyTest {
    private Executor executor;
    private AsynchronousEventProcessingStrategy testSubject;

    AsynchronousEventProcessingStrategyTest() {
    }

    @BeforeEach
    void setUp() {
        this.executor = (Executor)Mockito.mock(Executor.class);
        ((Executor)Mockito.doAnswer(invocation -> {
            UnitOfWork currentUnitOfWork = null;
            if (CurrentUnitOfWork.isStarted()) {
                currentUnitOfWork = CurrentUnitOfWork.get();
                CurrentUnitOfWork.clear((UnitOfWork)currentUnitOfWork);
            }
            ((Runnable)invocation.getArguments()[0]).run();
            if (currentUnitOfWork != null) {
                CurrentUnitOfWork.set((UnitOfWork)currentUnitOfWork);
            }
            return null;
        }).when((Object)this.executor)).execute((Runnable)Mockito.isA(Runnable.class));
        this.testSubject = new AsynchronousEventProcessingStrategy(this.executor, (SequencingPolicy)new SequentialPerAggregatePolicy());
    }

    @Test
    void orderingOfEvents() throws Exception {
        this.testSubject = new AsynchronousEventProcessingStrategy((Executor)Executors.newSingleThreadExecutor(), (SequencingPolicy)new SequentialPolicy());
        List ackedMessages = Collections.synchronizedList(new ArrayList());
        DomainEventMessage<String> event1 = EventTestUtils.createEvent(1L);
        DomainEventMessage<String> event2 = EventTestUtils.createEvent(2L);
        Consumer processor = (Consumer)Mockito.mock(Consumer.class);
        CountDownLatch latch = new CountDownLatch(2);
        ((Consumer)Mockito.doAnswer(invocation -> {
            List events = (List)invocation.getArguments()[0];
            events.forEach(e -> {
                ackedMessages.add(e);
                latch.countDown();
            });
            return null;
        }).when((Object)processor)).accept(Mockito.anyList());
        new DefaultUnitOfWork(null).execute(() -> {
            this.testSubject.handle(Collections.singletonList(event1), processor);
            this.testSubject.handle(Collections.singletonList(event2), processor);
        });
        latch.await();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{processor, processor});
        ((Consumer)inOrder.verify((Object)processor)).accept(Arrays.asList(event1, event2));
        Assertions.assertEquals((int)2, (int)ackedMessages.size());
        Assertions.assertEquals(event1, ackedMessages.get(0));
        Assertions.assertEquals(event2, ackedMessages.get(1));
    }

    @Test
    void eventsScheduledForHandling() {
        DomainEventMessage<String> message1 = EventTestUtils.createEvent("aggregate1", 1L);
        DomainEventMessage<String> message2 = EventTestUtils.createEvent("aggregate2", 1L);
        this.testSubject.handle(Arrays.asList(message1, message2), (Consumer)Mockito.mock(Consumer.class));
        ((Executor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)2))).execute((Runnable)Mockito.isA(Runnable.class));
    }

    @Test
    void eventsScheduledForHandlingWhenSurroundingUnitOfWorkCommits() {
        DomainEventMessage<String> message1 = EventTestUtils.createEvent("aggregate1", 1L);
        DomainEventMessage<String> message2 = EventTestUtils.createEvent("aggregate2", 1L);
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(message1);
        uow.onPrepareCommit(u -> ((Executor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.never())).execute((Runnable)Mockito.isA(Runnable.class)));
        this.testSubject.handle(Arrays.asList(message1, message2), (Consumer)Mockito.mock(Consumer.class));
        ((Executor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.never())).execute((Runnable)Mockito.isA(Runnable.class));
        uow.commit();
        ((Executor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)2))).execute((Runnable)Mockito.isA(Runnable.class));
    }
}

