/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.async;

import java.util.Collections;
import java.util.Map;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.async.MetaDataSequencingPolicy;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

@DisplayName(value="Unit-Test for the MetaDataSequencingPolicy")
public class MetaDataSequencingPolicyTest {
    @Test
    void propertyShouldReadCorrectValue() {
        MetaDataSequencingPolicy metaDataPolicy = MetaDataSequencingPolicy.builder().metaDataKey("metaDataKey").build();
        DomainEventMessage<?> testEvent = this.newStubDomainEvent("42", Collections.singletonMap("metaDataKey", "metaDataValue"));
        Assertions.assertEquals((Object)"metaDataValue", (Object)metaDataPolicy.getSequenceIdentifierFor(testEvent));
    }

    @Test
    void fallbackShouldBeAppliedWhenMetaDataDoesNotContainsTheKey() {
        MetaDataSequencingPolicy metaDataPolicy = MetaDataSequencingPolicy.builder().metaDataKey("metaDataKey").build();
        Assertions.assertNotNull((Object)metaDataPolicy.getSequenceIdentifierFor(this.newStubDomainEvent("42")));
    }

    @Test
    void missingHardRequirementShouldThrowException() {
        Assertions.assertThrows(AxonConfigurationException.class, () -> MetaDataSequencingPolicy.builder().build());
    }

    private DomainEventMessage<?> newStubDomainEvent(Object payload, Map<String, String> metaData) {
        return new GenericDomainEventMessage("type", "A", 0L, payload, (Map)MetaData.from(metaData));
    }

    private DomainEventMessage<?> newStubDomainEvent(Object payload) {
        return this.newStubDomainEvent(payload, Collections.emptyMap());
    }
}

