/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.deadletter.DeadLetteredEventProcessingTask;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.Decisions;
import org.axonframework.messaging.deadletter.DoNotEnqueue;
import org.axonframework.messaging.deadletter.EnqueueDecision;
import org.axonframework.messaging.deadletter.EnqueuePolicy;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DeadLetteredEventProcessingTaskTest {
    private static final EventMessage TEST_EVENT = GenericEventMessage.asEventMessage((Object)("Then this happened..." + UUID.randomUUID()));
    private static final EnqueueDecision<EventMessage<?>> TEST_DECISION = Decisions.ignore();
    private EventMessageHandler eventHandlerOne;
    private EventMessageHandler eventHandlerTwo;
    private EnqueuePolicy<EventMessage<?>> enqueuePolicy;
    private TransactionManager transactionManager;
    private List<EventMessageHandler> eventHandlingComponents;
    private DeadLetteredEventProcessingTask testSubject;

    DeadLetteredEventProcessingTaskTest() {
    }

    @BeforeEach
    void setUp() {
        this.eventHandlerOne = (EventMessageHandler)Mockito.mock(EventMessageHandler.class);
        this.eventHandlerTwo = (EventMessageHandler)Mockito.mock(EventMessageHandler.class);
        this.eventHandlingComponents = new ArrayList<EventMessageHandler>();
        this.eventHandlingComponents.add(this.eventHandlerOne);
        this.eventHandlingComponents.add(this.eventHandlerTwo);
        this.enqueuePolicy = (EnqueuePolicy)Mockito.mock(EnqueuePolicy.class);
        Mockito.when((Object)this.enqueuePolicy.decide((DeadLetter)Mockito.any(), (Throwable)Mockito.any())).thenReturn(TEST_DECISION);
        this.transactionManager = (TransactionManager)Mockito.spy((Object)new StubTransactionManager());
        this.testSubject = new DeadLetteredEventProcessingTask(this.eventHandlingComponents, Collections.emptyList(), this.enqueuePolicy, this.transactionManager);
    }

    @Test
    void taskProcessesLetterSuccessfully() throws Exception {
        DeadLetter testLetter = (DeadLetter)Mockito.mock(DeadLetter.class);
        Mockito.when((Object)testLetter.message()).thenReturn((Object)TEST_EVENT);
        EnqueueDecision result = this.testSubject.process(testLetter);
        Assertions.assertEquals(DoNotEnqueue.class, result.getClass());
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).startTransaction();
        ((EventMessageHandler)Mockito.verify((Object)this.eventHandlerOne)).handle(TEST_EVENT);
        ((EventMessageHandler)Mockito.verify((Object)this.eventHandlerTwo)).handle(TEST_EVENT);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.enqueuePolicy});
    }

    @Test
    void taskProcessesLetterUnsuccessfullyWhenHandlersThrowsAnException() throws Exception {
        DeadLetter testLetter = (DeadLetter)Mockito.mock(DeadLetter.class);
        Mockito.when((Object)testLetter.message()).thenReturn((Object)TEST_EVENT);
        RuntimeException testException = new RuntimeException();
        Mockito.when((Object)this.eventHandlerTwo.handle(TEST_EVENT)).thenThrow(new Throwable[]{testException});
        EnqueueDecision result = this.testSubject.process(testLetter);
        Assertions.assertEquals(TEST_DECISION, (Object)result);
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).startTransaction();
        ((EventMessageHandler)Mockito.verify((Object)this.eventHandlerOne)).handle(TEST_EVENT);
        ((EventMessageHandler)Mockito.verify((Object)this.eventHandlerTwo)).handle(TEST_EVENT);
        ((EnqueuePolicy)Mockito.verify(this.enqueuePolicy)).decide(testLetter, (Throwable)testException);
    }

    @Test
    void useInterceptorToHandleError() throws Exception {
        AtomicBoolean invoked = new AtomicBoolean(false);
        this.testSubject = new DeadLetteredEventProcessingTask(this.eventHandlingComponents, Collections.singletonList(this.errorCatchingInterceptor(invoked)), this.enqueuePolicy, this.transactionManager);
        DeadLetter testLetter = (DeadLetter)Mockito.mock(DeadLetter.class);
        Mockito.when((Object)testLetter.message()).thenReturn((Object)TEST_EVENT);
        RuntimeException testException = new RuntimeException();
        Mockito.when((Object)this.eventHandlerTwo.handle(TEST_EVENT)).thenThrow(new Throwable[]{testException});
        EnqueueDecision result = this.testSubject.process(testLetter);
        Assertions.assertFalse((boolean)result.shouldEnqueue());
        Assertions.assertTrue((boolean)invoked.get());
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).startTransaction();
        ((EventMessageHandler)Mockito.verify((Object)this.eventHandlerOne)).handle(TEST_EVENT);
        ((EventMessageHandler)Mockito.verify((Object)this.eventHandlerTwo)).handle(TEST_EVENT);
        ((EnqueuePolicy)Mockito.verify(this.enqueuePolicy, (VerificationMode)Mockito.never())).decide(testLetter, (Throwable)testException);
    }

    private MessageHandlerInterceptor<? super EventMessage<?>> errorCatchingInterceptor(AtomicBoolean invoked) {
        return (unitOfWork, chain) -> {
            invoked.set(true);
            try {
                chain.proceed();
            }
            catch (RuntimeException e) {
                return unitOfWork;
            }
            return unitOfWork;
        };
    }

    private static class StubTransactionManager
    implements TransactionManager {
        private StubTransactionManager() {
        }

        public Transaction startTransaction() {
            return NoTransactionManager.INSTANCE.startTransaction();
        }
    }
}

