/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import java.util.UUID;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedDomainEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterSchema;
import org.axonframework.eventhandling.deadletter.jdbc.DefaultDeadLetterJdbcConverter;
import org.axonframework.eventhandling.deadletter.jdbc.JdbcDeadLetter;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultDeadLetterJdbcConverterTest {
    private static final String AGGREGATE_ID = "aggregateId";
    private static final String AGGREGATE_TYPE = "aggregateType";
    private static final long SEQ_NO = 42L;
    private static final TrackingToken TRACKING_TOKEN = new GlobalSequenceTrackingToken(1L);
    private static final String CAUSE_TYPE = "causeType";
    private static final String CAUSE_MESSAGE = "causeMessage";
    private DeadLetterSchema schema;
    private Serializer genericSerializer;
    private Serializer eventSerializer;
    private DefaultDeadLetterJdbcConverter<?> testSubject;

    DefaultDeadLetterJdbcConverterTest() {
    }

    @BeforeEach
    void setUp() {
        this.schema = DeadLetterSchema.defaultSchema();
        this.eventSerializer = this.genericSerializer = TestSerializer.JACKSON.getSerializer();
        this.testSubject = DefaultDeadLetterJdbcConverter.builder().schema(this.schema).genericSerializer(this.genericSerializer).eventSerializer(this.eventSerializer).build();
    }

    @Test
    void convertToLetterConstructsGenericTrackedDomainEventMessage() throws SQLException {
        boolean withToken = true;
        boolean isDomainEvent = true;
        boolean withCause = true;
        ResultSet resultSet = this.mockedResultSet(withToken, isDomainEvent, withCause);
        JdbcDeadLetter result = this.testSubject.convertToLetter(resultSet);
        EventMessage resultMessage = result.message();
        Assertions.assertTrue((boolean)(resultMessage instanceof GenericTrackedDomainEventMessage));
        GenericTrackedDomainEventMessage castedResultMessage = (GenericTrackedDomainEventMessage)resultMessage;
        TrackingToken resultToken = castedResultMessage.trackingToken();
        Assertions.assertEquals((Object)TRACKING_TOKEN, (Object)resultToken);
        Assertions.assertEquals((Object)AGGREGATE_ID, (Object)castedResultMessage.getAggregateIdentifier());
        Assertions.assertEquals((Object)AGGREGATE_TYPE, (Object)castedResultMessage.getType());
        Assertions.assertEquals((long)42L, (long)castedResultMessage.getSequenceNumber());
    }

    @Test
    void convertToLetterConstructsGenericTrackedEventMessage() throws SQLException {
        boolean withToken = true;
        boolean isDomainEvent = false;
        boolean withCause = true;
        ResultSet resultSet = this.mockedResultSet(withToken, isDomainEvent, withCause);
        JdbcDeadLetter result = this.testSubject.convertToLetter(resultSet);
        EventMessage resultMessage = result.message();
        Assertions.assertTrue((boolean)(resultMessage instanceof GenericTrackedEventMessage));
        Assertions.assertEquals((Object)TRACKING_TOKEN, (Object)((GenericTrackedEventMessage)resultMessage).trackingToken());
    }

    @Test
    void convertToLetterConstructsGenericDomainEventMessage() throws SQLException {
        boolean withToken = false;
        boolean isDomainEvent = true;
        boolean withCause = true;
        ResultSet resultSet = this.mockedResultSet(withToken, isDomainEvent, withCause);
        JdbcDeadLetter result = this.testSubject.convertToLetter(resultSet);
        EventMessage resultMessage = result.message();
        Assertions.assertTrue((boolean)(resultMessage instanceof GenericDomainEventMessage));
        GenericDomainEventMessage castedResultMessage = (GenericDomainEventMessage)resultMessage;
        Assertions.assertEquals((Object)AGGREGATE_ID, (Object)castedResultMessage.getAggregateIdentifier());
        Assertions.assertEquals((Object)AGGREGATE_TYPE, (Object)castedResultMessage.getType());
        Assertions.assertEquals((long)42L, (long)castedResultMessage.getSequenceNumber());
    }

    @Test
    void convertToLetterConstructsGenericEventMessage() throws SQLException {
        boolean withToken = false;
        boolean isDomainEvent = false;
        boolean withCause = true;
        ResultSet resultSet = this.mockedResultSet(withToken, isDomainEvent, withCause);
        JdbcDeadLetter result = this.testSubject.convertToLetter(resultSet);
        Assertions.assertTrue((boolean)(result.message() instanceof GenericEventMessage));
    }

    @Test
    void convertToLetterConstructsWithCause() throws SQLException {
        boolean withToken = true;
        boolean isDomainEvent = true;
        boolean withCause = true;
        ResultSet resultSet = this.mockedResultSet(withToken, isDomainEvent, withCause);
        JdbcDeadLetter result = this.testSubject.convertToLetter(resultSet);
        Optional optionalCause = result.cause();
        Assertions.assertTrue((boolean)optionalCause.isPresent());
        Cause resultCause = (Cause)optionalCause.get();
        Assertions.assertEquals((Object)CAUSE_TYPE, (Object)resultCause.type());
        Assertions.assertEquals((Object)CAUSE_MESSAGE, (Object)resultCause.message());
    }

    @Test
    void convertToLetterConstructsWithoutCause() throws SQLException {
        boolean withToken = true;
        boolean isDomainEvent = true;
        boolean withCause = false;
        ResultSet resultSet = this.mockedResultSet(withToken, isDomainEvent, withCause);
        JdbcDeadLetter result = this.testSubject.convertToLetter(resultSet);
        Assertions.assertFalse((boolean)result.cause().isPresent());
    }

    private ResultSet mockedResultSet(boolean withToken, boolean isDomainEvent, boolean withCause) throws SQLException {
        ResultSet mock = (ResultSet)Mockito.mock(ResultSet.class);
        String timestamp = DateTimeUtils.formatInstant((TemporalAccessor)Instant.now());
        byte[] serializedPayload = (byte[])this.eventSerializer.serialize((Object)"some-payload", byte[].class).getData();
        byte[] serializedMetaData = (byte[])this.eventSerializer.serialize((Object)MetaData.emptyInstance(), byte[].class).getData();
        Mockito.when((Object)mock.getBytes(this.schema.payloadColumn())).thenReturn((Object)serializedPayload);
        Mockito.when((Object)mock.getString(this.schema.payloadTypeColumn())).thenReturn((Object)String.class.getName());
        Mockito.when((Object)mock.getBytes(this.schema.metaDataColumn())).thenReturn((Object)serializedMetaData);
        Mockito.when((Object)mock.getString(this.schema.eventIdentifierColumn())).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)mock.getString(this.schema.timestampColumn())).thenReturn((Object)timestamp);
        if (withToken) {
            Mockito.when((Object)mock.getString(this.schema.tokenTypeColumn())).thenReturn((Object)GlobalSequenceTrackingToken.class.getName());
            Mockito.when((Object)mock.getBytes(this.schema.tokenColumn())).thenReturn(this.genericSerializer.serialize((Object)TRACKING_TOKEN, byte[].class).getData());
        } else {
            Mockito.when((Object)mock.getString(this.schema.tokenTypeColumn())).thenReturn(null);
        }
        if (isDomainEvent) {
            Mockito.when((Object)mock.getString(this.schema.aggregateIdentifierColumn())).thenReturn((Object)AGGREGATE_ID);
            Mockito.when((Object)mock.getString(this.schema.aggregateTypeColumn())).thenReturn((Object)AGGREGATE_TYPE);
            Mockito.when((Object)mock.getLong(this.schema.sequenceNumberColumn())).thenReturn((Object)42L);
        } else {
            Mockito.when((Object)mock.getString(this.schema.aggregateIdentifierColumn())).thenReturn(null);
        }
        Mockito.when((Object)mock.getString(this.schema.deadLetterIdentifierColumn())).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)mock.getLong(this.schema.sequenceIndexColumn())).thenReturn((Object)1337L);
        Mockito.when((Object)mock.getString(this.schema.sequenceIdentifierColumn())).thenReturn((Object)UUID.randomUUID().toString());
        Mockito.when((Object)mock.getString(this.schema.enqueuedAtColumn())).thenReturn((Object)timestamp);
        Mockito.when((Object)mock.getString(this.schema.lastTouchedColumn())).thenReturn((Object)timestamp);
        Mockito.when((Object)mock.getBytes(this.schema.diagnosticsColumn())).thenReturn((Object)serializedMetaData);
        if (withCause) {
            Mockito.when((Object)mock.getString(this.schema.causeTypeColumn())).thenReturn((Object)CAUSE_TYPE);
            Mockito.when((Object)mock.getString(this.schema.causeMessageColumn())).thenReturn((Object)CAUSE_MESSAGE);
        } else {
            Mockito.when((Object)mock.getString(this.schema.causeTypeColumn())).thenReturn(null);
        }
        return mock;
    }

    @Test
    void buildWithNullSchemaThrowsAxonConfigurationException() {
        DefaultDeadLetterJdbcConverter.Builder testBuilder = DefaultDeadLetterJdbcConverter.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.schema(null));
    }

    @Test
    void buildWithNullGenericSerializerThrowsAxonConfigurationException() {
        DefaultDeadLetterJdbcConverter.Builder testBuilder = DefaultDeadLetterJdbcConverter.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.genericSerializer(null));
    }

    @Test
    void buildWithNullEventSerializerThrowsAxonConfigurationException() {
        DefaultDeadLetterJdbcConverter.Builder testBuilder = DefaultDeadLetterJdbcConverter.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.eventSerializer(null));
    }

    @Test
    void buildWithoutTheGenericSerializerThrowsAxonConfigurationException() {
        DefaultDeadLetterJdbcConverter.Builder testBuilder = DefaultDeadLetterJdbcConverter.builder().eventSerializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((DefaultDeadLetterJdbcConverter.Builder)testBuilder).build());
    }

    @Test
    void buildWithoutTheEventSerializerThrowsAxonConfigurationException() {
        DefaultDeadLetterJdbcConverter.Builder testBuilder = DefaultDeadLetterJdbcConverter.builder().genericSerializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((DefaultDeadLetterJdbcConverter.Builder)testBuilder).build());
    }
}

