/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.deadletter.jdbc.DefaultDeadLetterStatementFactory;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultDeadLetterStatementFactoryTest {
    DefaultDeadLetterStatementFactoryTest() {
    }

    @Test
    void buildWithNullSchemaThrowsAxonConfigurationException() {
        DefaultDeadLetterStatementFactory.Builder testBuilder = DefaultDeadLetterStatementFactory.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.schema(null));
    }

    @Test
    void buildWithNullGenericSerializerThrowsAxonConfigurationException() {
        DefaultDeadLetterStatementFactory.Builder testBuilder = DefaultDeadLetterStatementFactory.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.genericSerializer(null));
    }

    @Test
    void buildWithNullEventSerializerThrowsAxonConfigurationException() {
        DefaultDeadLetterStatementFactory.Builder testBuilder = DefaultDeadLetterStatementFactory.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.eventSerializer(null));
    }

    @Test
    void buildWithoutTheGenericSerializerThrowsAxonConfigurationException() {
        DefaultDeadLetterStatementFactory.Builder testBuilder = DefaultDeadLetterStatementFactory.builder().eventSerializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((DefaultDeadLetterStatementFactory.Builder)testBuilder).build());
    }

    @Test
    void buildWithoutTheEventSerializerThrowsAxonConfigurationException() {
        DefaultDeadLetterStatementFactory.Builder testBuilder = DefaultDeadLetterStatementFactory.builder().genericSerializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((DefaultDeadLetterStatementFactory.Builder)testBuilder).build());
    }
}

