/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.JdbcException;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.deadletter.DeadLetteringEventIntegrationTest;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterSchema;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterStatementFactory;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterTableFactory;
import org.axonframework.eventhandling.deadletter.jdbc.DefaultDeadLetterStatementFactory;
import org.axonframework.eventhandling.deadletter.jdbc.GenericDeadLetterTableFactory;
import org.axonframework.eventhandling.deadletter.jdbc.JdbcDeadLetter;
import org.axonframework.eventhandling.deadletter.jdbc.JdbcSequencedDeadLetterQueue;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.TestSerializer;
import org.hsqldb.jdbc.JDBCDataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

class JdbcDeadLetteringEventIntegrationTest
extends DeadLetteringEventIntegrationTest {
    private static final String TEST_PROCESSING_GROUP = "some-processing-group";
    private DataSource dataSource;
    private TransactionManager transactionManager;
    private DeadLetterStatementFactory<EventMessage<?>> statementFactory;
    private JdbcSequencedDeadLetterQueue<EventMessage<?>> jdbcDeadLetterQueue;
    private final DeadLetterSchema schema = DeadLetterSchema.defaultSchema();

    JdbcDeadLetteringEventIntegrationTest() {
    }

    @Override
    protected SequencedDeadLetterQueue<EventMessage<?>> buildDeadLetterQueue() {
        this.dataSource = this.dataSource();
        this.transactionManager = this.transactionManager(this.dataSource);
        Serializer eventSerializer = TestSerializer.JACKSON.getSerializer();
        Serializer genericSerializer = TestSerializer.JACKSON.getSerializer();
        this.statementFactory = DefaultDeadLetterStatementFactory.builder().eventSerializer(eventSerializer).genericSerializer(genericSerializer).schema(this.schema).build();
        this.jdbcDeadLetterQueue = JdbcSequencedDeadLetterQueue.builder().processingGroup(TEST_PROCESSING_GROUP).connectionProvider(this.dataSource::getConnection).schema(this.schema).statementFactory(this.statementFactory).transactionManager(this.transactionManager).genericSerializer(eventSerializer).eventSerializer(genericSerializer).build();
        return this.jdbcDeadLetterQueue;
    }

    private DataSource dataSource() {
        JDBCDataSource dataSource = new JDBCDataSource();
        dataSource.setUrl("jdbc:hsqldb:mem:axontest");
        dataSource.setUser("sa");
        dataSource.setPassword("");
        return dataSource;
    }

    private TransactionManager transactionManager(DataSource dataSource) {
        DataSourceTransactionManager platformTransactionManager = new DataSourceTransactionManager(dataSource);
        return () -> this.lambda$transactionManager$0((PlatformTransactionManager)platformTransactionManager);
    }

    @BeforeEach
    void setUpJdbc() {
        this.transactionManager.executeInTransaction(() -> {
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                connection.prepareStatement("DROP TABLE IF EXISTS " + this.schema.deadLetterTable()).executeUpdate();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Enable to retrieve a Connection to drop the dead-letter queue", e);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            this.jdbcDeadLetterQueue.createSchema((DeadLetterTableFactory)new GenericDeadLetterTableFactory());
        });
    }

    @Test
    void deadLetterSequenceReturnsMatchingEnqueuedLettersInInsertOrder() {
        String aggregateId = UUID.randomUUID().toString();
        HashMap insertedLetters = new HashMap();
        Iterator resultIterator = this.jdbcDeadLetterQueue.deadLetterSequence((Object)aggregateId).iterator();
        Assertions.assertFalse((boolean)resultIterator.hasNext());
        IntStream.range(0, 64).boxed().sorted(Collections.reverseOrder()).forEach(i -> {
            GenericDeadLetter letter = new GenericDeadLetter((Object)aggregateId, (Message)GenericEventMessage.asEventMessage((Object)i));
            this.insertLetterAtIndex(aggregateId, (DeadLetter<EventMessage<?>>)letter, (int)i);
            insertedLetters.put(i, letter);
        });
        resultIterator = this.jdbcDeadLetterQueue.deadLetterSequence((Object)aggregateId).iterator();
        for (Map.Entry entry : insertedLetters.entrySet()) {
            Integer sequenceIndex = (Integer)entry.getKey();
            Supplier<String> assertMessageSupplier = () -> "Failed asserting event [" + sequenceIndex + "]";
            Assertions.assertTrue((boolean)resultIterator.hasNext(), assertMessageSupplier);
            GenericDeadLetter expected = (GenericDeadLetter)entry.getValue();
            DeadLetter result = (DeadLetter)resultIterator.next();
            Assertions.assertTrue((boolean)(result instanceof JdbcDeadLetter));
            JdbcDeadLetter actual = (JdbcDeadLetter)result;
            Assertions.assertEquals((Object)expected.getSequenceIdentifier(), (Object)actual.getSequenceIdentifier(), assertMessageSupplier);
            Assertions.assertEquals((Object)((EventMessage)expected.message()).getPayload(), (Object)actual.message().getPayload(), assertMessageSupplier);
            Assertions.assertFalse((boolean)result.cause().isPresent(), assertMessageSupplier);
            Assertions.assertEquals((Object)expected.diagnostics(), (Object)actual.diagnostics(), assertMessageSupplier);
            Assertions.assertEquals((long)sequenceIndex.longValue(), (long)actual.getSequenceIndex(), assertMessageSupplier);
        }
    }

    private void insertLetterAtIndex(String aggregateId, DeadLetter<EventMessage<?>> letter, int index) {
        this.transactionManager.executeInTransaction(() -> {
            try (Connection connection = this.dataSource.getConnection();){
                JdbcUtils.executeUpdate((Connection)connection, c -> this.statementFactory.enqueueStatement(c, TEST_PROCESSING_GROUP, aggregateId, letter, (long)index), e -> new JdbcException("Failed to enqueue dead letter with with message id [" + ((EventMessage)letter.message()).getIdentifier() + "] during testing", (Throwable)e));
            }
            catch (SQLException e2) {
                throw new RuntimeException(e2);
            }
        });
    }

    private /* synthetic */ Transaction lambda$transactionManager$0(final PlatformTransactionManager platformTransactionManager) {
        final TransactionStatus transaction = platformTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        return new Transaction(){

            public void commit() {
                platformTransactionManager.commit(transaction);
            }

            public void rollback() {
                platformTransactionManager.rollback(transaction);
            }
        };
    }
}

