/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import javax.sql.DataSource;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterJdbcConverter;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterSchema;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterStatementFactory;
import org.axonframework.eventhandling.deadletter.jdbc.DeadLetterTableFactory;
import org.axonframework.eventhandling.deadletter.jdbc.GenericDeadLetterTableFactory;
import org.axonframework.eventhandling.deadletter.jdbc.JdbcDeadLetter;
import org.axonframework.eventhandling.deadletter.jdbc.JdbcSequencedDeadLetterQueue;
import org.axonframework.messaging.deadletter.Cause;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueue;
import org.axonframework.messaging.deadletter.SequencedDeadLetterQueueTest;
import org.axonframework.messaging.deadletter.WrongDeadLetterTypeException;
import org.axonframework.serialization.TestSerializer;
import org.hsqldb.jdbc.JDBCDataSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

class JdbcSequencedDeadLetterQueueTest
extends SequencedDeadLetterQueueTest<EventMessage<?>> {
    private static final int MAX_SEQUENCES_AND_SEQUENCE_SIZE = 64;
    private static final String TEST_PROCESSING_GROUP = "some-processing-group";
    private DataSource dataSource;
    private TransactionManager transactionManager;
    private JdbcSequencedDeadLetterQueue<EventMessage<?>> jdbcDeadLetterQueue;
    private final DeadLetterSchema schema = DeadLetterSchema.defaultSchema();

    JdbcSequencedDeadLetterQueueTest() {
    }

    @Override
    protected SequencedDeadLetterQueue<EventMessage<?>> buildTestSubject() {
        this.dataSource = this.dataSource();
        this.transactionManager = this.transactionManager(this.dataSource);
        this.jdbcDeadLetterQueue = JdbcSequencedDeadLetterQueue.builder().processingGroup(TEST_PROCESSING_GROUP).maxSequences(64).maxSequenceSize(64).connectionProvider(this.dataSource::getConnection).schema(this.schema).transactionManager(this.transactionManager).genericSerializer(TestSerializer.JACKSON.getSerializer()).eventSerializer(TestSerializer.JACKSON.getSerializer()).build();
        return this.jdbcDeadLetterQueue;
    }

    private DataSource dataSource() {
        JDBCDataSource dataSource = new JDBCDataSource();
        dataSource.setUrl("jdbc:hsqldb:mem:axontest");
        dataSource.setUser("sa");
        dataSource.setPassword("");
        return dataSource;
    }

    private TransactionManager transactionManager(DataSource dataSource) {
        DataSourceTransactionManager platformTransactionManager = new DataSourceTransactionManager(dataSource);
        return () -> this.lambda$transactionManager$0((PlatformTransactionManager)platformTransactionManager);
    }

    @BeforeEach
    void setUpJdbc() {
        this.transactionManager.executeInTransaction(() -> {
            Connection connection = null;
            try {
                connection = this.dataSource.getConnection();
                connection.prepareStatement("DROP TABLE IF EXISTS " + this.schema.deadLetterTable()).executeUpdate();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Enable to retrieve a Connection to drop the dead-letter queue", e);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            this.jdbcDeadLetterQueue.createSchema((DeadLetterTableFactory)new GenericDeadLetterTableFactory());
        });
    }

    @Override
    protected long maxSequences() {
        return 64L;
    }

    @Override
    protected long maxSequenceSize() {
        return 64L;
    }

    @Override
    public DeadLetter<EventMessage<?>> generateInitialLetter() {
        return new GenericDeadLetter((Object)"sequenceIdentifier", JdbcSequencedDeadLetterQueueTest.generateEvent(), JdbcSequencedDeadLetterQueueTest.generateThrowable());
    }

    @Override
    protected DeadLetter<EventMessage<?>> generateFollowUpLetter() {
        return new GenericDeadLetter((Object)"sequenceIdentifier", JdbcSequencedDeadLetterQueueTest.generateEvent());
    }

    @Override
    protected DeadLetter<EventMessage<?>> mapToQueueImplementation(DeadLetter<EventMessage<?>> deadLetter) {
        if (deadLetter instanceof JdbcDeadLetter) {
            return deadLetter;
        }
        if (deadLetter instanceof GenericDeadLetter) {
            return new JdbcDeadLetter(IdentifierFactory.getInstance().generateIdentifier(), 0L, ((GenericDeadLetter)deadLetter).getSequenceIdentifier().toString(), deadLetter.enqueuedAt(), deadLetter.lastTouched(), (Cause)deadLetter.cause().orElse(null), deadLetter.diagnostics(), (EventMessage)deadLetter.message());
        }
        throw new IllegalArgumentException("Can not map dead letter of type " + deadLetter.getClass().getName());
    }

    @Override
    protected void setClock(Clock clock) {
        GenericDeadLetter.clock = clock;
    }

    @Override
    protected void assertLetter(DeadLetter<? extends EventMessage<?>> expected, DeadLetter<? extends EventMessage<?>> actual) {
        EventMessage expectedMessage = (EventMessage)expected.message();
        EventMessage actualMessage = (EventMessage)actual.message();
        Assertions.assertEquals((Object)expectedMessage.getPayload(), (Object)actualMessage.getPayload());
        Assertions.assertEquals((Object)expectedMessage.getPayloadType(), (Object)actualMessage.getPayloadType());
        Assertions.assertEquals((Object)expectedMessage.getMetaData(), (Object)actualMessage.getMetaData());
        Assertions.assertEquals((Object)expectedMessage.getIdentifier(), (Object)actualMessage.getIdentifier());
        Assertions.assertEquals((Object)expected.cause(), (Object)actual.cause());
        Assertions.assertEquals((Object)JdbcSequencedDeadLetterQueueTest.formatExpected(expected.enqueuedAt()), (Object)actual.enqueuedAt());
        Assertions.assertEquals((Object)JdbcSequencedDeadLetterQueueTest.formatExpected(expected.lastTouched()), (Object)actual.lastTouched());
        Assertions.assertEquals((Object)expected.diagnostics(), (Object)actual.diagnostics());
    }

    private static Instant formatExpected(Instant expected) {
        return DateTimeUtils.parseInstant((CharSequence)DateTimeUtils.formatInstant((TemporalAccessor)expected));
    }

    @Test
    void invokingEvictWithNonJdbcDeadLetterThrowsWrongDeadLetterTypeException() {
        DeadLetter<EventMessage<?>> testLetter = this.generateInitialLetter();
        Assertions.assertThrows(WrongDeadLetterTypeException.class, () -> this.jdbcDeadLetterQueue.evict(testLetter));
    }

    @Test
    void buildWithNullProcessingGroupThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.processingGroup(null));
    }

    @Test
    void buildWithEmptyProcessingGroupThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.processingGroup(""));
    }

    @Test
    void buildWithNullConnectionProviderThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.connectionProvider(null));
    }

    @Test
    void buildWithNullTransactionManagerThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.transactionManager(null));
    }

    @Test
    void buildWithNullSchemaThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.schema(null));
    }

    @Test
    void buildWithNullStatementFactoryThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.statementFactory(null));
    }

    @Test
    void buildWithNullConverterThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.converter(null));
    }

    @Test
    void buildWithNullGenericSerializerThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.genericSerializer(null));
    }

    @Test
    void buildWithNullEventSerializerThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.eventSerializer(null));
    }

    @Test
    void buildWithZeroMaxSequencesThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.maxSequences(0));
    }

    @Test
    void buildWithNegativeMaxSequencesThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.maxSequences(-1));
    }

    @Test
    void buildWithZeroMaxSequenceSizeThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.maxSequenceSize(0));
    }

    @Test
    void buildWithNegativeMaxSequenceSizeThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.maxSequenceSize(-1));
    }

    @Test
    void buildWithNullClaimDurationThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.claimDuration(null));
    }

    @Test
    void buildWithZeroPageSizeThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.pageSize(0));
    }

    @Test
    void buildWithNegativePageSizeThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder();
        Assertions.assertThrows(AxonConfigurationException.class, () -> testBuilder.pageSize(-1));
    }

    @Test
    void buildWithoutProcessingGroupThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder().connectionProvider((ConnectionProvider)Mockito.mock(ConnectionProvider.class)).transactionManager(NoTransactionManager.instance()).statementFactory((DeadLetterStatementFactory)Mockito.mock(DeadLetterStatementFactory.class)).converter((DeadLetterJdbcConverter)Mockito.mock(DeadLetterJdbcConverter.class));
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((JdbcSequencedDeadLetterQueue.Builder)testBuilder).build());
    }

    @Test
    void buildWithoutConnectionProviderThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder().processingGroup(TEST_PROCESSING_GROUP).transactionManager(NoTransactionManager.instance()).statementFactory((DeadLetterStatementFactory)Mockito.mock(DeadLetterStatementFactory.class)).converter((DeadLetterJdbcConverter)Mockito.mock(DeadLetterJdbcConverter.class));
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((JdbcSequencedDeadLetterQueue.Builder)testBuilder).build());
    }

    @Test
    void buildWithoutTransactionManagerThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder().processingGroup(TEST_PROCESSING_GROUP).connectionProvider((ConnectionProvider)Mockito.mock(ConnectionProvider.class)).statementFactory((DeadLetterStatementFactory)Mockito.mock(DeadLetterStatementFactory.class)).converter((DeadLetterJdbcConverter)Mockito.mock(DeadLetterJdbcConverter.class));
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((JdbcSequencedDeadLetterQueue.Builder)testBuilder).build());
    }

    @Test
    void buildWithoutStatementFactoryAndGenericSerializersThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder().processingGroup(TEST_PROCESSING_GROUP).connectionProvider((ConnectionProvider)Mockito.mock(ConnectionProvider.class)).converter((DeadLetterJdbcConverter)Mockito.mock(DeadLetterJdbcConverter.class)).eventSerializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((JdbcSequencedDeadLetterQueue.Builder)testBuilder).build());
    }

    @Test
    void buildWithoutStatementFactoryAndEventSerializersThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder().processingGroup(TEST_PROCESSING_GROUP).connectionProvider((ConnectionProvider)Mockito.mock(ConnectionProvider.class)).converter((DeadLetterJdbcConverter)Mockito.mock(DeadLetterJdbcConverter.class)).genericSerializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((JdbcSequencedDeadLetterQueue.Builder)testBuilder).build());
    }

    @Test
    void buildWithoutConverterAndGenericSerializersThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder().processingGroup(TEST_PROCESSING_GROUP).connectionProvider((ConnectionProvider)Mockito.mock(ConnectionProvider.class)).statementFactory((DeadLetterStatementFactory)Mockito.mock(DeadLetterStatementFactory.class)).eventSerializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((JdbcSequencedDeadLetterQueue.Builder)testBuilder).build());
    }

    @Test
    void buildWithoutConverterAndEventSerializersThrowsAxonConfigurationException() {
        JdbcSequencedDeadLetterQueue.Builder testBuilder = JdbcSequencedDeadLetterQueue.builder().processingGroup(TEST_PROCESSING_GROUP).connectionProvider((ConnectionProvider)Mockito.mock(ConnectionProvider.class)).statementFactory((DeadLetterStatementFactory)Mockito.mock(DeadLetterStatementFactory.class)).genericSerializer(TestSerializer.JACKSON.getSerializer());
        Assertions.assertThrows(AxonConfigurationException.class, () -> ((JdbcSequencedDeadLetterQueue.Builder)testBuilder).build());
    }

    private /* synthetic */ Transaction lambda$transactionManager$0(final PlatformTransactionManager platformTransactionManager) {
        final TransactionStatus transaction = platformTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        return new Transaction(){

            public void commit() {
                platformTransactionManager.commit(transaction);
            }

            public void rollback() {
                platformTransactionManager.rollback(transaction);
            }
        };
    }
}

