/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.deadletter.jpa;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedDomainEventMessage;
import org.axonframework.eventhandling.GenericTrackedEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.deadletter.jpa.DeadLetterEventEntry;
import org.axonframework.eventhandling.deadletter.jpa.EventMessageDeadLetterJpaConverter;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.Revision;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EventMessageDeadLetterJpaConverterTest {
    private static final String PAYLOAD_REVISION = "23.0";
    private final EventMessageDeadLetterJpaConverter converter = new EventMessageDeadLetterJpaConverter();
    private final Serializer eventSerializer = TestSerializer.JACKSON.getSerializer();
    private final Serializer genericSerializer = TestSerializer.XSTREAM.getSerializer();
    private final ConverterTestEvent event = new ConverterTestEvent("myValue");
    private final MetaData metaData = MetaData.from(Collections.singletonMap("myMetadataKey", "myMetadataValue"));

    EventMessageDeadLetterJpaConverterTest() {
    }

    @Test
    void canConvertGenericEventMessageAndBackCorrectly() {
        this.testConversion(GenericEventMessage.asEventMessage((Object)this.event).andMetaData((Map)this.metaData));
    }

    @Test
    void canConvertDomainEventMessageAndBackCorrectly() {
        this.testConversion((EventMessage<?>)new GenericDomainEventMessage("MyType", "8239081092", 25L, (Object)this.event, (Map)this.metaData));
    }

    @Test
    void canConvertTrackedDomainEventMessageWithGlobalSequenceTokenAndBackCorrectly() {
        this.testConversion((EventMessage<?>)new GenericTrackedDomainEventMessage((TrackingToken)new GlobalSequenceTrackingToken(232323L), "MyType", "8239081092", 25L, (Message)new GenericEventMessage((Object)this.event, (Map)this.metaData), Instant::now));
    }

    @Test
    void canConvertMessagesWithSerializationErrors() {
        SimpleSerializedType eventType = new SimpleSerializedType("org.axonframework.eventhandling.deadletter.jpa.EventMessageDeadLetterJpaConverterTest$SerializationErrorClass", null);
        GenericEventMessage message = new GenericEventMessage((Message)new SerializedMessage("my-identifier", (SerializedObject)new SimpleSerializedObject((Object)"{'my-wrong-payload':'wadawd'}".getBytes(StandardCharsets.UTF_8), byte[].class, (SerializedType)eventType), (SerializedObject)new SimpleSerializedObject((Object)"{}".getBytes(StandardCharsets.UTF_8), byte[].class, (SerializedType)new SimpleSerializedType("org.axonframework.messaging.MetaData", null)), this.eventSerializer), Instant::now);
        DeadLetterEventEntry deadLetterEventEntry = this.converter.convert((EventMessage)message, this.eventSerializer, this.genericSerializer);
        Assertions.assertNotNull((Object)deadLetterEventEntry);
        Assertions.assertEquals((Object)"{'my-wrong-payload':'wadawd'}", (Object)new String((byte[])deadLetterEventEntry.getPayload().getData()));
    }

    @Test
    void canConvertTrackedDomainEventMessageWithGapAwareTokenAndBackCorrectly() {
        GapAwareTrackingToken testToken = new GapAwareTrackingToken(232323L, Arrays.asList(24L, 255L, 2225L));
        this.testConversion((EventMessage<?>)new GenericTrackedDomainEventMessage((TrackingToken)testToken, "MyType", "8239081092", 25L, (Message)new GenericEventMessage((Object)this.event, (Map)this.metaData), Instant::now));
    }

    @Test
    void canConvertTrackedEventMessageWithGlobalSequenceTokenAndBackCorrectly() {
        this.testConversion((EventMessage<?>)new GenericTrackedEventMessage((TrackingToken)new GlobalSequenceTrackingToken(232323L), (Message)new GenericEventMessage((Object)this.event, (Map)this.metaData), Instant::now));
    }

    @Test
    void canConvertTrackedEventMessageWithGapAwareTokenAndBackCorrectly() {
        GapAwareTrackingToken testToken = new GapAwareTrackingToken(232323L, Arrays.asList(24L, 255L, 2225L));
        this.testConversion((EventMessage<?>)new GenericTrackedEventMessage((TrackingToken)testToken, (Message)new GenericEventMessage((Object)this.event, (Map)this.metaData), Instant::now));
    }

    private void testConversion(EventMessage<?> message) {
        Assertions.assertTrue((boolean)this.converter.canConvert(message));
        DeadLetterEventEntry deadLetterEventEntry = this.converter.convert(message, this.eventSerializer, this.genericSerializer);
        this.assertCorrectlyMapped(message, deadLetterEventEntry);
        Assertions.assertTrue((boolean)this.converter.canConvert(deadLetterEventEntry));
        EventMessage restoredEventMessage = this.converter.convert(deadLetterEventEntry, this.eventSerializer, this.genericSerializer);
        this.assertCorrectlyRestored(message, restoredEventMessage);
    }

    private void assertCorrectlyRestored(EventMessage<?> expected, EventMessage<?> actual) {
        Assertions.assertEquals((Object)expected.getIdentifier(), (Object)actual.getIdentifier());
        Assertions.assertEquals((Object)expected.getTimestamp(), (Object)actual.getTimestamp());
        Assertions.assertEquals((Object)expected.getPayload(), (Object)actual.getPayload());
        Assertions.assertEquals((Object)expected.getPayloadType(), (Object)actual.getPayloadType());
        Assertions.assertEquals((Object)expected.getMetaData(), (Object)actual.getMetaData());
        Assertions.assertEquals(expected.getClass(), actual.getClass());
        if (expected instanceof DomainEventMessage) {
            DomainEventMessage domainExpected = (DomainEventMessage)expected;
            DomainEventMessage domainActual = (DomainEventMessage)actual;
            Assertions.assertEquals((Object)domainExpected.getType(), (Object)domainActual.getType());
            Assertions.assertEquals((Object)domainExpected.getAggregateIdentifier(), (Object)domainActual.getAggregateIdentifier());
            Assertions.assertEquals((long)domainExpected.getSequenceNumber(), (long)domainActual.getSequenceNumber());
        }
        if (expected instanceof TrackedEventMessage) {
            TrackedEventMessage trackedExpected = (TrackedEventMessage)expected;
            TrackedEventMessage trackedActual = (TrackedEventMessage)actual;
            Assertions.assertEquals((Object)trackedExpected.trackingToken(), (Object)trackedActual.trackingToken());
        }
    }

    private void assertCorrectlyMapped(EventMessage<?> eventMessage, DeadLetterEventEntry deadLetterEventEntry) {
        Assertions.assertEquals((Object)eventMessage.getIdentifier(), (Object)deadLetterEventEntry.getEventIdentifier());
        Assertions.assertEquals((Object)eventMessage.getTimestamp().toString(), (Object)deadLetterEventEntry.getTimeStamp());
        Assertions.assertEquals((Object)eventMessage.getPayload().getClass().getName(), (Object)deadLetterEventEntry.getPayload().getType().getName());
        Assertions.assertEquals((Object)PAYLOAD_REVISION, (Object)deadLetterEventEntry.getPayload().getType().getRevision());
        Assertions.assertEquals((Object)this.eventSerializer.serialize((Object)this.event, String.class).getData(), (Object)new String((byte[])deadLetterEventEntry.getPayload().getData()));
        Assertions.assertEquals((Object)MetaData.class.getName(), (Object)deadLetterEventEntry.getMetaData().getType().getName());
        Assertions.assertEquals((Object)this.eventSerializer.serialize((Object)this.metaData, String.class).getData(), (Object)new String((byte[])deadLetterEventEntry.getMetaData().getData()));
        if (eventMessage instanceof DomainEventMessage) {
            DomainEventMessage domainEventMessage = (DomainEventMessage)eventMessage;
            Assertions.assertEquals((Object)domainEventMessage.getType(), (Object)deadLetterEventEntry.getType());
            Assertions.assertEquals((Object)domainEventMessage.getAggregateIdentifier(), (Object)deadLetterEventEntry.getAggregateIdentifier());
            Assertions.assertEquals((long)domainEventMessage.getSequenceNumber(), (Long)deadLetterEventEntry.getSequenceNumber());
        } else {
            Assertions.assertNull((Object)deadLetterEventEntry.getType());
            Assertions.assertNull((Object)deadLetterEventEntry.getAggregateIdentifier());
            Assertions.assertNull((Object)deadLetterEventEntry.getSequenceNumber());
        }
        if (eventMessage instanceof TrackedEventMessage) {
            TrackedEventMessage trackedEventMessage = (TrackedEventMessage)eventMessage;
            Assertions.assertEquals((Object)trackedEventMessage.trackingToken().getClass().getName(), (Object)deadLetterEventEntry.getTrackingToken().getType().getName());
            Assertions.assertEquals((Object)this.genericSerializer.serialize((Object)trackedEventMessage.trackingToken(), String.class).getData(), (Object)new String((byte[])deadLetterEventEntry.getTrackingToken().getData()));
        } else {
            Assertions.assertNull((Object)deadLetterEventEntry.getTrackingToken());
        }
    }

    static class SerializationErrorClass {
        String myValue;

        SerializationErrorClass() {
        }
    }

    @Revision(value="23.0")
    public static class ConverterTestEvent {
        private final String myProperty;

        @JsonCreator
        public ConverterTestEvent(@JsonProperty(value="myProperty") String myProperty) {
            this.myProperty = myProperty;
        }

        public String getMyProperty() {
            return this.myProperty;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConverterTestEvent that = (ConverterTestEvent)o;
            return Objects.equals(this.myProperty, that.myProperty);
        }

        public int hashCode() {
            return this.myProperty != null ? this.myProperty.hashCode() : 0;
        }
    }
}

