/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay;

import java.util.Collections;
import java.util.Map;
import org.axonframework.eventhandling.replay.GenericResetContext;
import org.axonframework.eventhandling.replay.ResetContext;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericResetContextTest {
    private static final Object TEST_PAYLOAD = new Object();

    GenericResetContextTest() {
    }

    @Test
    void constructor() {
        ResetContext messageOne = GenericResetContext.asResetContext((Object)TEST_PAYLOAD);
        ResetContext messageTwo = GenericResetContext.asResetContext((Object)new GenericMessage(TEST_PAYLOAD));
        ResetContext messageThree = GenericResetContext.asResetContext((Object)new GenericResetContext(TEST_PAYLOAD));
        Map<String, String> metaDataMap = Collections.singletonMap("key", "value");
        GenericResetContext messageFour = new GenericResetContext(TEST_PAYLOAD, metaDataMap);
        MetaData metaData = MetaData.from(metaDataMap);
        GenericResetContext messageFive = new GenericResetContext(TEST_PAYLOAD, (Map)metaData);
        Assertions.assertSame((Object)MetaData.emptyInstance(), (Object)messageOne.getMetaData());
        Assertions.assertEquals(Object.class, messageOne.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)messageOne.getPayloadType());
        Assertions.assertSame((Object)MetaData.emptyInstance(), (Object)messageTwo.getMetaData());
        Assertions.assertEquals(Object.class, messageTwo.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)messageTwo.getPayloadType());
        Assertions.assertSame((Object)MetaData.emptyInstance(), (Object)messageThree.getMetaData());
        Assertions.assertEquals(Object.class, messageThree.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)messageThree.getPayloadType());
        Assertions.assertNotSame(metaDataMap, (Object)messageFour.getMetaData());
        Assertions.assertEquals(metaDataMap, (Object)messageFour.getMetaData());
        Assertions.assertEquals(Object.class, messageFour.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)messageFour.getPayloadType());
        Assertions.assertSame((Object)metaData, (Object)messageFive.getMetaData());
        Assertions.assertEquals(Object.class, messageFive.getPayload().getClass());
        Assertions.assertEquals(Object.class, (Object)messageFive.getPayloadType());
        Assertions.assertNotEquals((Object)messageOne.getIdentifier(), (Object)messageFour.getIdentifier());
        Assertions.assertNotEquals((Object)messageFour.getIdentifier(), (Object)messageFive.getIdentifier());
        Assertions.assertNotEquals((Object)messageFive.getIdentifier(), (Object)messageOne.getIdentifier());
    }

    @Test
    void withMetaData() {
        MetaData metaData = MetaData.from(Collections.singletonMap("key", "value"));
        GenericResetContext startMessage = new GenericResetContext(TEST_PAYLOAD, (Map)metaData);
        ResetContext messageOne = startMessage.withMetaData((Map)MetaData.emptyInstance());
        ResetContext messageTwo = startMessage.withMetaData((Map)MetaData.from(Collections.singletonMap("key", "otherValue")));
        Assertions.assertEquals((int)0, (int)messageOne.getMetaData().size());
        Assertions.assertEquals((int)1, (int)messageTwo.getMetaData().size());
    }

    @Test
    void andMetaData() {
        MetaData metaData = MetaData.from(Collections.singletonMap("key", "value"));
        GenericResetContext startMessage = new GenericResetContext(TEST_PAYLOAD, (Map)metaData);
        ResetContext messageOne = startMessage.andMetaData((Map)MetaData.emptyInstance());
        ResetContext messageTwo = startMessage.andMetaData((Map)MetaData.from(Collections.singletonMap("key", "otherValue")));
        Assertions.assertEquals((int)1, (int)messageOne.getMetaData().size());
        Assertions.assertEquals((Object)"value", (Object)messageOne.getMetaData().get((Object)"key"));
        Assertions.assertEquals((int)1, (int)messageTwo.getMetaData().size());
        Assertions.assertEquals((Object)"otherValue", (Object)messageTwo.getMetaData().get((Object)"key"));
    }

    @Test
    void describeType() {
        Assertions.assertEquals((Object)"GenericResetContext", (Object)new GenericResetContext(TEST_PAYLOAD).describeType());
    }
}

