/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.dbscheduler;

import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskInstance;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Supplier;
import org.awaitility.Awaitility;
import org.axonframework.eventhandling.scheduling.dbscheduler.AbstractDbSchedulerEventSchedulerTest;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerBinaryEventData;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerEventScheduler;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerEventSchedulerSupplier;
import org.axonframework.utils.DbSchedulerTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BinaryDbSchedulerEventSchedulerTest
extends AbstractDbSchedulerEventSchedulerTest {
    BinaryDbSchedulerEventSchedulerTest() {
    }

    @Override
    Task<?> getTask(Supplier<DbSchedulerEventScheduler> eventSchedulerSupplier) {
        return DbSchedulerEventScheduler.binaryTask(eventSchedulerSupplier);
    }

    @Override
    boolean useBinaryPojo() {
        return true;
    }

    @Test
    void whenNotInitializedThrow() {
        this.eventScheduler.shutdown();
        DbSchedulerEventSchedulerSupplier supplier = new DbSchedulerEventSchedulerSupplier();
        this.scheduler = DbSchedulerTestUtil.getScheduler(this.dataSource, this.getTask((Supplier<DbSchedulerEventScheduler>)supplier));
        this.scheduler.start();
        try {
            TaskInstance instance = DbSchedulerEventScheduler.binaryTask((Supplier)supplier).instance("id", (Object)new DbSchedulerBinaryEventData());
            this.scheduler.schedule(instance, Instant.now());
            Awaitility.await().atMost(Duration.ofSeconds(1L)).untilAsserted(() -> {
                List failures = this.scheduler.getFailingExecutions(Duration.ofHours(1L));
                Assertions.assertEquals((int)1, (int)failures.size());
                Assertions.assertNotNull((Object)((Execution)failures.get((int)0)).lastFailure);
            });
        }
        finally {
            this.scheduler.stop();
        }
    }
}

