/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.dbscheduler;

import java.util.Collection;
import java.util.UUID;
import org.axonframework.eventhandling.scheduling.dbscheduler.DbSchedulerScheduleToken;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DbScheduledScheduleTokenTest {
    DbScheduledScheduleTokenTest() {
    }

    @Test
    void equalsIfSameUuidIsUsed() {
        String uuid = UUID.randomUUID().toString();
        DbSchedulerScheduleToken one = new DbSchedulerScheduleToken(uuid);
        DbSchedulerScheduleToken other = new DbSchedulerScheduleToken(uuid);
        Assertions.assertEquals((Object)one, (Object)other);
        Assertions.assertEquals((Object)one.toString(), (Object)other.toString());
        Assertions.assertEquals((int)one.hashCode(), (int)other.hashCode());
    }

    @Test
    void notEqualsIfDifferentUuidIsUsed() {
        DbSchedulerScheduleToken one = new DbSchedulerScheduleToken(UUID.randomUUID().toString());
        DbSchedulerScheduleToken other = new DbSchedulerScheduleToken(UUID.randomUUID().toString());
        Assertions.assertNotEquals((Object)one, (Object)other);
        Assertions.assertNotEquals((Object)one.toString(), (Object)other.toString());
        Assertions.assertNotEquals((int)one.hashCode(), (int)other.hashCode());
    }

    @MethodSource(value={"serializers"})
    @ParameterizedTest
    void tokenShouldBeSerializable(TestSerializer serializer) {
        DbSchedulerScheduleToken tokenToTest = new DbSchedulerScheduleToken(UUID.randomUUID().toString());
        Assertions.assertEquals((Object)tokenToTest, (Object)serializer.serializeDeserialize(tokenToTest));
    }

    public static Collection<TestSerializer> serializers() {
        return TestSerializer.all();
    }
}

