/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Duration;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.ScheduleToken;
import org.axonframework.eventhandling.scheduling.java.SimpleEventScheduler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class SimpleEventSchedulerTest {
    private ScheduledExecutorService scheduledExecutorService;
    private EventBus eventBus;
    private SimpleEventScheduler testSubject;

    SimpleEventSchedulerTest() {
    }

    @BeforeEach
    void setUp() {
        this.eventBus = (EventBus)Mockito.mock(EventBus.class);
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.testSubject = SimpleEventScheduler.builder().scheduledExecutorService(this.scheduledExecutorService).eventBus(this.eventBus).build();
    }

    @AfterEach
    void tearDown() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    @Test
    void scheduleJob() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ((EventBus)Mockito.doAnswer(invocation -> {
            latch.countDown();
            return null;
        }).when((Object)this.eventBus)).publish(new EventMessage[]{(EventMessage)Mockito.isA(EventMessage.class)});
        this.testSubject.schedule(Duration.ofMillis(30L), new Object());
        latch.await(1L, TimeUnit.SECONDS);
        ((EventBus)Mockito.verify((Object)this.eventBus)).publish(new EventMessage[]{(EventMessage)Mockito.isA(EventMessage.class)});
    }

    @Test
    void scheduleTokenIsSerializable() throws IOException, ClassNotFoundException {
        ScheduleToken token = this.testSubject.schedule(Duration.ZERO, new Object());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(token);
        oos.close();
        ScheduleToken token2 = (ScheduleToken)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        this.testSubject.cancelSchedule(token2);
    }

    @Test
    void cancelJob() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ((EventBus)Mockito.doAnswer(invocation -> {
            latch.countDown();
            return null;
        }).when((Object)this.eventBus)).publish(new EventMessage[]{(EventMessage)Mockito.isA(EventMessage.class)});
        EventMessage<Object> event1 = this.createEvent();
        EventMessage<Object> event2 = this.createEvent();
        ScheduleToken token1 = this.testSubject.schedule(Duration.ofMillis(100L), event1);
        this.testSubject.schedule(Duration.ofMillis(120L), event2);
        this.testSubject.cancelSchedule(token1);
        latch.await(1L, TimeUnit.SECONDS);
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).publish(new EventMessage[]{event1});
        ((EventBus)Mockito.verify((Object)this.eventBus)).publish(new EventMessage[]{(EventMessage)Mockito.argThat(item -> item != null && event2.getPayload().equals(item.getPayload()) && event2.getMetaData().equals((Object)item.getMetaData()))});
        this.scheduledExecutorService.shutdown();
        Assertions.assertTrue((boolean)this.scheduledExecutorService.awaitTermination(1L, TimeUnit.SECONDS), (String)"Executor refused to shutdown within a second");
    }

    @Test
    void shutdownInvokesExecutorServiceShutdown(@Mock ScheduledExecutorService scheduledExecutorService) {
        SimpleEventScheduler testSubject = SimpleEventScheduler.builder().scheduledExecutorService(scheduledExecutorService).eventBus(this.eventBus).build();
        testSubject.shutdown();
        ((ScheduledExecutorService)Mockito.verify((Object)scheduledExecutorService)).shutdown();
    }

    private EventMessage<Object> createEvent() {
        return new GenericEventMessage(new Object());
    }
}

