/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.jobrunr;

import java.util.Collection;
import java.util.UUID;
import org.axonframework.eventhandling.scheduling.jobrunr.JobRunrScheduleToken;
import org.axonframework.serialization.TestSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class JobRunrScheduleTokenTest {
    JobRunrScheduleTokenTest() {
    }

    @Test
    void equalsIfSameUuidIsUsed() {
        UUID uuid = UUID.randomUUID();
        JobRunrScheduleToken one = new JobRunrScheduleToken(uuid);
        JobRunrScheduleToken other = new JobRunrScheduleToken(uuid);
        Assertions.assertEquals((Object)one, (Object)other);
        Assertions.assertEquals((Object)one.toString(), (Object)other.toString());
        Assertions.assertEquals((int)one.hashCode(), (int)other.hashCode());
    }

    @Test
    void notEqualsIfDifferentUuidIsUsed() {
        JobRunrScheduleToken one = new JobRunrScheduleToken(UUID.randomUUID());
        JobRunrScheduleToken other = new JobRunrScheduleToken(UUID.randomUUID());
        Assertions.assertNotEquals((Object)one, (Object)other);
        Assertions.assertNotEquals((Object)one.toString(), (Object)other.toString());
        Assertions.assertNotEquals((int)one.hashCode(), (int)other.hashCode());
    }

    @MethodSource(value={"serializers"})
    @ParameterizedTest
    void tokenShouldBeSerializable(TestSerializer serializer) {
        JobRunrScheduleToken tokenToTest = new JobRunrScheduleToken(UUID.randomUUID());
        Assertions.assertEquals((Object)tokenToTest, (Object)serializer.serializeDeserialize(tokenToTest));
    }

    public static Collection<TestSerializer> serializers() {
        return TestSerializer.all();
    }
}

