/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.quartz;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.scheduling.quartz.QuartzEventScheduler;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.JavaSerializer;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.TestSerializer;
import org.axonframework.serialization.json.JacksonSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatcher;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.quartz.JobDataMap;

class DirectEventJobDataBinderTest {
    private static final String TEST_EVENT_PAYLOAD = "event-payload";
    private final EventMessage<String> testEventMessage;
    private final MetaData testMetaData = MetaData.with((String)"some-key", (Object)"some-value");

    DirectEventJobDataBinderTest() {
        this.testEventMessage = GenericEventMessage.asEventMessage((Object)TEST_EVENT_PAYLOAD).withMetaData((Map)this.testMetaData);
    }

    static Stream<Arguments> serializerImplementationAndAssertionSpecifics() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{Mockito.spy((Object)JavaSerializer.builder().build()), Class::getName, Objects::nonNull}), Arguments.arguments((Object[])new Object[]{Mockito.spy((Object)TestSerializer.XSTREAM.getSerializer()), clazz -> clazz.getSimpleName().toLowerCase(), Objects::isNull}), Arguments.arguments((Object[])new Object[]{Mockito.spy((Object)JacksonSerializer.builder().build()), Class::getName, Objects::isNull}));
    }

    @MethodSource(value={"serializerImplementationAndAssertionSpecifics"})
    @ParameterizedTest
    void eventMessageToJobData(Serializer serializer, Function<Class, String> expectedSerializedClassType, Predicate<Object> revisionMatcher) {
        QuartzEventScheduler.DirectEventJobDataBinder testSubject = new QuartzEventScheduler.DirectEventJobDataBinder(serializer);
        JobDataMap result = testSubject.toJobData(this.testEventMessage);
        Assertions.assertEquals((Object)this.testEventMessage.getIdentifier(), (Object)result.get((Object)"axon-message-id"));
        Assertions.assertEquals((Object)this.testEventMessage.getTimestamp().toString(), (Object)result.get((Object)"axon-message-timestamp"));
        String expectedPayloadType = expectedSerializedClassType.apply(this.testEventMessage.getPayloadType());
        Assertions.assertEquals((Object)expectedPayloadType, (Object)result.get((Object)"axon-message-type"));
        Object resultRevision = result.get((Object)"axon-message-revision");
        Assertions.assertTrue((boolean)revisionMatcher.test(resultRevision));
        Assertions.assertNotNull((Object)result.get((Object)"axon-serialized-message-payload"));
        Assertions.assertNotNull((Object)result.get((Object)"axon-metadata"));
        ((Serializer)Mockito.verify((Object)serializer)).serialize((Object)TEST_EVENT_PAYLOAD, byte[].class);
        ((Serializer)Mockito.verify((Object)serializer)).serialize((Object)this.testMetaData, byte[].class);
    }

    @MethodSource(value={"serializerImplementationAndAssertionSpecifics"})
    @ParameterizedTest
    void eventMessageFromJobData(Serializer serializer, Function<Class, String> expectedSerializedClassType, Predicate<Object> revisionMatcher) {
        QuartzEventScheduler.DirectEventJobDataBinder testSubject = new QuartzEventScheduler.DirectEventJobDataBinder(serializer);
        JobDataMap testJobDataMap = testSubject.toJobData(this.testEventMessage);
        Object result = testSubject.fromJobData(testJobDataMap);
        Assertions.assertTrue((boolean)(result instanceof EventMessage));
        EventMessage resultEventMessage = (EventMessage)result;
        Assertions.assertEquals((Object)this.testEventMessage.getIdentifier(), (Object)resultEventMessage.getIdentifier());
        Assertions.assertEquals((Object)this.testEventMessage.getTimestamp(), (Object)resultEventMessage.getTimestamp());
        Assertions.assertEquals((Object)this.testEventMessage.getPayload(), (Object)resultEventMessage.getPayload());
        Assertions.assertEquals((Object)this.testEventMessage.getPayloadType(), (Object)resultEventMessage.getPayloadType());
        Assertions.assertEquals((Object)this.testEventMessage.getMetaData(), (Object)resultEventMessage.getMetaData());
        ((Serializer)Mockito.verify((Object)serializer, (VerificationMode)Mockito.times((int)2))).deserialize((SerializedObject)Mockito.argThat((ArgumentMatcher)new MatchEventMessageSerializedObject(expectedSerializedClassType, revisionMatcher)));
    }

    private static class MatchEventMessageSerializedObject
    implements ArgumentMatcher<SimpleSerializedObject<?>> {
        private final Function<Class, String> expectedSerializedClassType;
        private final Predicate<Object> revisionMatcher;

        MatchEventMessageSerializedObject(Function<Class, String> expectedSerializedClassType, Predicate<Object> revisionMatcher) {
            this.expectedSerializedClassType = expectedSerializedClassType;
            this.revisionMatcher = revisionMatcher;
        }

        public boolean matches(SimpleSerializedObject<?> serializedObject) {
            String expectedSerializedPayloadType = this.expectedSerializedClassType.apply(DirectEventJobDataBinderTest.TEST_EVENT_PAYLOAD.getClass());
            SerializedType type = serializedObject.getType();
            String serializedTypeName = type.getName();
            boolean isSerializedMetaData = serializedTypeName.equals(MetaData.class.getName());
            return !(serializedObject.getData() == null || !serializedObject.getContentType().equals(byte[].class) || !serializedTypeName.equals(expectedSerializedPayloadType) && !isSerializedMetaData || !isSerializedMetaData && !this.revisionMatcher.test(type.getRevision()));
        }
    }
}

