/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.inmemory;

import java.util.Arrays;
import java.util.List;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.inmemory.InMemoryTokenStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class InMemoryTokenStoreTest {
    private InMemoryTokenStore testSubject;

    InMemoryTokenStoreTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = new InMemoryTokenStore();
    }

    @Test
    void initializeTokens() {
        this.testSubject.initializeTokenSegments("test1", 7);
        int[] actual = this.testSubject.fetchSegments("test1");
        Arrays.sort(actual);
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])actual);
    }

    @Test
    void identifierIsPresent() {
        Assertions.assertTrue((boolean)this.testSubject.retrieveStorageIdentifier().isPresent());
    }

    @Test
    void initializeTokensAtGivenPosition() {
        this.testSubject.initializeTokenSegments("test1", 7, (TrackingToken)new GlobalSequenceTrackingToken(10L));
        int[] actual = this.testSubject.fetchSegments("test1");
        Arrays.sort(actual);
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])actual);
        for (int segment : actual) {
            Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(10L), (Object)this.testSubject.fetchToken("test1", segment));
        }
    }

    @Test
    void updateToken() {
        this.testSubject.initializeTokenSegments("test1", 1);
        this.testSubject.storeToken((TrackingToken)new GlobalSequenceTrackingToken(1L), "test1", 0);
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(1L), (Object)this.testSubject.fetchToken("test1", 0));
    }

    @Test
    void initializeAtGivenToken() {
        this.testSubject.initializeTokenSegments("test1", 2, (TrackingToken)new GlobalSequenceTrackingToken(1L));
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(1L), (Object)this.testSubject.fetchToken("test1", 0));
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(1L), (Object)this.testSubject.fetchToken("test1", 1));
    }

    @Test
    void initializeTokensWhileAlreadyPresent() {
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.testSubject.fetchToken("test1", 1));
    }

    @Test
    void querySegments() {
        this.testSubject.initializeTokenSegments("test", 1);
        Assertions.assertNull((Object)this.testSubject.fetchToken("test", 0));
        this.testSubject.storeToken((TrackingToken)new GlobalSequenceTrackingToken(1L), "proc1", 0);
        this.testSubject.storeToken((TrackingToken)new GlobalSequenceTrackingToken(2L), "proc1", 1);
        this.testSubject.storeToken((TrackingToken)new GlobalSequenceTrackingToken(2L), "proc2", 1);
        int[] segments = this.testSubject.fetchSegments("proc1");
        MatcherAssert.assertThat((Object)segments.length, (Matcher)CoreMatchers.is((Object)2));
        segments = this.testSubject.fetchSegments("proc2");
        MatcherAssert.assertThat((Object)segments.length, (Matcher)CoreMatchers.is((Object)1));
        segments = this.testSubject.fetchSegments("proc3");
        MatcherAssert.assertThat((Object)segments.length, (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    void queryAvailableSegments() {
        this.testSubject.storeToken((TrackingToken)new GlobalSequenceTrackingToken(1L), "proc1", 0);
        this.testSubject.storeToken((TrackingToken)new GlobalSequenceTrackingToken(2L), "proc1", 1);
        this.testSubject.storeToken((TrackingToken)new GlobalSequenceTrackingToken(2L), "proc2", 1);
        List segments = this.testSubject.fetchAvailableSegments("proc1");
        MatcherAssert.assertThat((Object)segments.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((Segment)segments.get(0)).getSegmentId(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)((Segment)segments.get(1)).getSegmentId(), (Matcher)CoreMatchers.is((Object)1));
        segments = this.testSubject.fetchAvailableSegments("proc2");
        MatcherAssert.assertThat((Object)segments.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Segment)segments.get(0)).getSegmentId(), (Matcher)CoreMatchers.is((Object)1));
        segments = this.testSubject.fetchAvailableSegments("proc3");
        MatcherAssert.assertThat((Object)segments.size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

