/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.tokenstore.legacyjpa;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.LockModeType;
import javax.persistence.Persistence;
import org.axonframework.common.legacyjpa.EntityManagerProvider;
import org.axonframework.common.legacyjpa.SimpleEntityManagerProvider;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.Segment;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventhandling.tokenstore.ConfigToken;
import org.axonframework.eventhandling.tokenstore.UnableToClaimTokenException;
import org.axonframework.eventhandling.tokenstore.jpa.TokenEntry;
import org.axonframework.eventhandling.tokenstore.legacyjpa.JpaTokenStore;
import org.axonframework.serialization.TestSerializer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class JpaTokenStoreTest {
    private final EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"tokenstore");
    private final EntityManager entityManager = this.entityManagerFactory.createEntityManager();
    private final EntityManagerProvider entityManagerProvider = new SimpleEntityManagerProvider(this.entityManager);
    private final JpaTokenStore jpaTokenStore = this.getTokenStore("local", null);
    private final JpaTokenStore concurrentJpaTokenStore = this.getTokenStore("concurrent", Duration.ofSeconds(2L));
    private final JpaTokenStore stealingJpaTokenStore = this.getTokenStore("stealing", Duration.ofSeconds(-1L));
    private EntityTransaction transaction;

    JpaTokenStoreTest() {
    }

    @BeforeEach
    public void setUp() {
        this.transaction = this.entityManager.getTransaction();
        this.transaction.begin();
    }

    @AfterEach
    public void cleanup() {
        this.transaction.commit();
    }

    @Test
    void updateNullToken() {
        this.jpaTokenStore.initializeTokenSegments("test", 1);
        this.jpaTokenStore.fetchToken("test", 0);
        this.jpaTokenStore.storeToken(null, "test", 0);
        List tokens = this.entityManager.createQuery("SELECT t FROM TokenEntry t WHERE t.processorName = :processorName", TokenEntry.class).setParameter("processorName", (Object)"test").getResultList();
        Assertions.assertEquals((int)1, (int)tokens.size());
        Assertions.assertNotNull((Object)((TokenEntry)tokens.get(0)).getOwner());
        Assertions.assertNull((Object)((TokenEntry)tokens.get(0)).getToken(TestSerializer.XSTREAM.getSerializer()));
    }

    @Test
    void updateAndLoadNullToken() {
        this.jpaTokenStore.initializeTokenSegments("test", 1);
        this.jpaTokenStore.fetchToken("test", 0);
        this.entityManager.flush();
        this.jpaTokenStore.storeToken(null, "test", 0);
        this.entityManager.flush();
        this.entityManager.clear();
        TrackingToken token = this.jpaTokenStore.fetchToken("test", 0);
        Assertions.assertNull((Object)token);
    }

    @Test
    void identifierInitializedOnDemand() {
        Optional id1 = this.jpaTokenStore.retrieveStorageIdentifier();
        Assertions.assertTrue((boolean)id1.isPresent());
        Optional id2 = this.jpaTokenStore.retrieveStorageIdentifier();
        Assertions.assertTrue((boolean)id2.isPresent());
        Assertions.assertEquals(id1.get(), id2.get());
    }

    @Test
    void identifierReadIfAvailable() {
        this.entityManager.persist((Object)new TokenEntry("__config", 0, (TrackingToken)new ConfigToken(Collections.singletonMap("id", "test")), this.jpaTokenStore.serializer()));
        Optional id1 = this.jpaTokenStore.retrieveStorageIdentifier();
        Assertions.assertTrue((boolean)id1.isPresent());
        Optional id2 = this.jpaTokenStore.retrieveStorageIdentifier();
        Assertions.assertTrue((boolean)id2.isPresent());
        Assertions.assertEquals(id1.get(), id2.get());
        Assertions.assertEquals((Object)"test", id1.get());
    }

    @Test
    void customLockMode() {
        EntityManager spyEntityManager = (EntityManager)Mockito.mock(EntityManager.class);
        JpaTokenStore testSubject = JpaTokenStore.builder().serializer(TestSerializer.XSTREAM.getSerializer()).loadingLockMode(LockModeType.NONE).entityManagerProvider((EntityManagerProvider)new SimpleEntityManagerProvider(spyEntityManager)).nodeId("test").build();
        try {
            testSubject.fetchToken("processorName", 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((EntityManager)Mockito.verify((Object)spyEntityManager)).find((Class)ArgumentMatchers.eq(TokenEntry.class), ArgumentMatchers.any(), (LockModeType)ArgumentMatchers.eq((Object)LockModeType.NONE));
    }

    @Test
    void initializeTokens() {
        this.jpaTokenStore.initializeTokenSegments("test1", 7);
        int[] actual = this.jpaTokenStore.fetchSegments("test1");
        Arrays.sort(actual);
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])actual);
    }

    @Test
    void initializeTokensAtGivenPosition() {
        this.jpaTokenStore.initializeTokenSegments("test1", 7, (TrackingToken)new GlobalSequenceTrackingToken(10L));
        int[] actual = this.jpaTokenStore.fetchSegments("test1");
        Arrays.sort(actual);
        Assertions.assertArrayEquals((int[])new int[]{0, 1, 2, 3, 4, 5, 6}, (int[])actual);
        for (int segment : actual) {
            Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(10L), (Object)this.jpaTokenStore.fetchToken("test1", segment));
        }
    }

    @Test
    void initializeTokensWhileAlreadyPresent() {
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.jpaTokenStore.fetchToken("test1", 1));
    }

    @Test
    void deleteTokenRejectedIfNotClaimedOrNotInitialized() {
        this.jpaTokenStore.initializeTokenSegments("test", 2);
        try {
            this.jpaTokenStore.deleteToken("test", 0);
            Assertions.fail((String)"Expected delete to fail");
        }
        catch (UnableToClaimTokenException unableToClaimTokenException) {
            // empty catch block
        }
        try {
            this.jpaTokenStore.deleteToken("unknown", 0);
            Assertions.fail((String)"Expected delete to fail");
        }
        catch (UnableToClaimTokenException unableToClaimTokenException) {
            // empty catch block
        }
    }

    @Test
    void deleteToken() {
        this.jpaTokenStore.initializeSegment(null, "delete", 0);
        this.jpaTokenStore.fetchToken("delete", 0);
        this.entityManager.flush();
        this.jpaTokenStore.deleteToken("delete", 0);
        Assertions.assertEquals((long)0L, (long)((Long)this.entityManager.createQuery("SELECT count(t) FROM TokenEntry t WHERE t.processorName = :processorName", Long.class).setParameter("processorName", (Object)"delete").getSingleResult()));
    }

    @Test
    void claimAndUpdateToken() {
        this.jpaTokenStore.initializeTokenSegments("test", 1);
        Assertions.assertNull((Object)this.jpaTokenStore.fetchToken("test", 0));
        this.jpaTokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(1L), "test", 0);
        List tokens = this.entityManager.createQuery("SELECT t FROM TokenEntry t WHERE t.processorName = :processorName", TokenEntry.class).setParameter("processorName", (Object)"test").getResultList();
        Assertions.assertEquals((int)1, (int)tokens.size());
        Assertions.assertNotNull((Object)((TokenEntry)tokens.get(0)).getOwner());
        this.jpaTokenStore.releaseClaim("test", 0);
        this.entityManager.flush();
        this.entityManager.clear();
        TokenEntry token = (TokenEntry)this.entityManager.find(TokenEntry.class, (Object)new TokenEntry.PK("test", 0));
        Assertions.assertNull((Object)token.getOwner());
    }

    @Test
    void fetchTokenBySegment() {
        this.jpaTokenStore.initializeTokenSegments("test", 2);
        Segment segmentToFetch = Segment.computeSegment((int)1, (int[])new int[]{0, 1});
        Assertions.assertNull((Object)this.jpaTokenStore.fetchToken("test", segmentToFetch));
    }

    @Test
    void fetchTokenBySegmentSegment0() {
        this.jpaTokenStore.initializeTokenSegments("test", 1);
        Segment segmentToFetch = Segment.computeSegment((int)0, (int[])new int[]{0});
        Assertions.assertNull((Object)this.jpaTokenStore.fetchToken("test", segmentToFetch));
    }

    @Test
    void fetchTokenBySegmentFailsDuringMerge() {
        this.jpaTokenStore.initializeTokenSegments("test", 1);
        Segment segmentToFetch = Segment.computeSegment((int)1, (int[])new int[]{0, 1});
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.jpaTokenStore.fetchToken("test", segmentToFetch));
    }

    @Test
    void fetchTokenBySegmentFailsDuringMergeSegment0() {
        this.jpaTokenStore.initializeTokenSegments("test", 1);
        Segment segmentToFetch = Segment.computeSegment((int)0, (int[])new int[]{0, 1});
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.jpaTokenStore.fetchToken("test", segmentToFetch));
    }

    @Test
    void fetchTokenBySegmentFailsDuringSplit() {
        this.jpaTokenStore.initializeTokenSegments("test", 4);
        Segment segmentToFetch = Segment.computeSegment((int)1, (int[])new int[]{0, 1});
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.jpaTokenStore.fetchToken("test", segmentToFetch));
    }

    @Test
    void fetchTokenBySegmentFailsDuringSplitSegment0() {
        this.jpaTokenStore.initializeTokenSegments("test", 2);
        Segment segmentToFetch = Segment.computeSegment((int)0, (int[])new int[]{0});
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.jpaTokenStore.fetchToken("test", segmentToFetch));
    }

    @Test
    void querySegments() {
        this.prepareTokenStore();
        int[] segments = this.jpaTokenStore.fetchSegments("proc1");
        MatcherAssert.assertThat((Object)segments.length, (Matcher)CoreMatchers.is((Object)2));
        segments = this.jpaTokenStore.fetchSegments("proc2");
        MatcherAssert.assertThat((Object)segments.length, (Matcher)CoreMatchers.is((Object)1));
        segments = this.jpaTokenStore.fetchSegments("proc3");
        MatcherAssert.assertThat((Object)segments.length, (Matcher)CoreMatchers.is((Object)0));
        this.entityManager.flush();
        this.entityManager.clear();
    }

    @Test
    void queryAvailableSegments() {
        this.prepareTokenStore();
        List segments = this.concurrentJpaTokenStore.fetchAvailableSegments("proc1");
        MatcherAssert.assertThat((Object)segments.size(), (Matcher)CoreMatchers.is((Object)0));
        this.jpaTokenStore.releaseClaim("proc1", 0);
        this.entityManager.flush();
        this.entityManager.clear();
        List segmentsAfterRelease = this.concurrentJpaTokenStore.fetchAvailableSegments("proc1");
        MatcherAssert.assertThat((Object)segmentsAfterRelease.size(), (Matcher)CoreMatchers.is((Object)1));
        segments = this.concurrentJpaTokenStore.fetchAvailableSegments("proc2");
        MatcherAssert.assertThat((Object)segments.size(), (Matcher)CoreMatchers.is((Object)0));
        this.jpaTokenStore.releaseClaim("proc2", 0);
        this.entityManager.flush();
        this.entityManager.clear();
        segmentsAfterRelease = this.concurrentJpaTokenStore.fetchAvailableSegments("proc2");
        MatcherAssert.assertThat((Object)segmentsAfterRelease.size(), (Matcher)CoreMatchers.is((Object)1));
        segments = this.jpaTokenStore.fetchAvailableSegments("proc3");
        MatcherAssert.assertThat((Object)segments.size(), (Matcher)CoreMatchers.is((Object)0));
        this.entityManager.flush();
        this.entityManager.clear();
    }

    private void prepareTokenStore() {
        this.jpaTokenStore.initializeTokenSegments("test", 1);
        this.jpaTokenStore.initializeTokenSegments("proc1", 2);
        this.jpaTokenStore.initializeTokenSegments("proc2", 1);
        Assertions.assertNull((Object)this.jpaTokenStore.fetchToken("test", 0));
        this.jpaTokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(1L), "proc1", 0);
        this.jpaTokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(2L), "proc1", 1);
        this.jpaTokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(2L), "proc2", 0);
    }

    @Test
    void claimTokenConcurrently() {
        this.jpaTokenStore.initializeTokenSegments("concurrent", 1);
        this.jpaTokenStore.fetchToken("concurrent", 0);
        try {
            this.concurrentJpaTokenStore.fetchToken("concurrent", 0);
            Assertions.fail((String)"Expected UnableToClaimTokenException");
        }
        catch (UnableToClaimTokenException unableToClaimTokenException) {
            // empty catch block
        }
    }

    @Test
    void stealToken() {
        GlobalSequenceTrackingToken testToken = new GlobalSequenceTrackingToken(0L);
        this.jpaTokenStore.initializeTokenSegments("stealing", 1);
        this.jpaTokenStore.fetchToken("stealing", 0);
        this.stealingJpaTokenStore.fetchToken("stealing", 0);
        Assertions.assertThrows(UnableToClaimTokenException.class, () -> this.lambda$stealToken$5((TrackingToken)testToken));
        this.jpaTokenStore.releaseClaim("stealing", 0);
        this.stealingJpaTokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(1L), "stealing", 0);
    }

    @Test
    void extendingLostClaimFails() {
        this.jpaTokenStore.initializeTokenSegments("processor", 1);
        this.jpaTokenStore.fetchToken("processor", 0);
        try {
            this.stealingJpaTokenStore.extendClaim("processor", 0);
            Assertions.fail((String)"Expected claim extension to fail");
        }
        catch (UnableToClaimTokenException unableToClaimTokenException) {
            // empty catch block
        }
    }

    @Test
    void storeAndLoadAcrossTransactions() {
        this.jpaTokenStore.initializeTokenSegments("multi", 1);
        this.newTransAction();
        this.jpaTokenStore.fetchToken("multi", 0);
        this.jpaTokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(1L), "multi", 0);
        this.newTransAction();
        TrackingToken actual = this.jpaTokenStore.fetchToken("multi", 0);
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(1L), (Object)actual);
        this.jpaTokenStore.storeToken((TrackingToken)new GlobalSequenceTrackingToken(2L), "multi", 0);
        this.newTransAction();
        actual = this.jpaTokenStore.fetchToken("multi", 0);
        Assertions.assertEquals((Object)new GlobalSequenceTrackingToken(2L), (Object)actual);
    }

    private JpaTokenStore getTokenStore(String nodeId, @Nullable TemporalAmount claimTimeOut) {
        JpaTokenStore.Builder builder = JpaTokenStore.builder().entityManagerProvider(this.entityManagerProvider).serializer(TestSerializer.XSTREAM.getSerializer()).nodeId(nodeId);
        if (!Objects.isNull(claimTimeOut)) {
            builder.claimTimeout(claimTimeOut);
        }
        return builder.build();
    }

    private void newTransAction() {
        this.entityManager.flush();
        this.entityManager.clear();
        this.transaction.commit();
        this.transaction = this.entityManager.getTransaction();
        this.transaction.begin();
    }

    private /* synthetic */ void lambda$stealToken$5(TrackingToken testToken) throws Throwable {
        this.jpaTokenStore.storeToken(testToken, "stealing", 0);
    }
}

