/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import java.util.Arrays;
import org.axonframework.messaging.DefaultInterceptorChain;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandler;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultInterceptorChainTest {
    private UnitOfWork<Message<?>> unitOfWork;
    private MessageHandler<Message<?>> mockHandler;

    DefaultInterceptorChainTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.unitOfWork = new DefaultUnitOfWork(null);
        this.mockHandler = (MessageHandler)Mockito.mock(MessageHandler.class);
        Mockito.when((Object)this.mockHandler.handle((Message)Mockito.isA(Message.class))).thenReturn((Object)"Result");
    }

    @Test
    void chainWithDifferentProceedCalls() throws Exception {
        MessageHandlerInterceptor interceptor1 = (unitOfWork, interceptorChain) -> {
            unitOfWork.transformMessage(m -> new GenericMessage((Object)"testing"));
            return interceptorChain.proceed();
        };
        MessageHandlerInterceptor interceptor2 = (unitOfWork, interceptorChain) -> interceptorChain.proceed();
        this.unitOfWork.transformMessage(m -> new GenericMessage((Object)"original"));
        DefaultInterceptorChain testSubject = new DefaultInterceptorChain(this.unitOfWork, Arrays.asList(interceptor1, interceptor2), this.mockHandler);
        String actual = (String)testSubject.proceed();
        Assertions.assertSame((Object)"Result", (Object)actual);
        ((MessageHandler)Mockito.verify(this.mockHandler)).handle((Message)Mockito.argThat(x -> x != null && x.getPayload().equals("testing")));
    }
}

