/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import java.util.Collections;
import java.util.HashMap;
import org.axonframework.messaging.HandlerAttributes;
import org.axonframework.messaging.SimpleHandlerAttributes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SimpleHandlerAttributesTest {
    private static final String ATTRIBUTE_KEY = "some-handler.some-attribute";
    private static final int ATTRIBUTE = 42;

    SimpleHandlerAttributesTest() {
    }

    @Test
    void constructEmptyHandlerAttributes() {
        SimpleHandlerAttributes testSubject = new SimpleHandlerAttributes(Collections.emptyMap());
        Assertions.assertTrue((boolean)testSubject.isEmpty());
    }

    @Test
    void constructNonEmptyHandlerAttributes() {
        HashMap<String, Integer> testAttributes = new HashMap<String, Integer>();
        testAttributes.put(ATTRIBUTE_KEY, 42);
        SimpleHandlerAttributes testSubject = new SimpleHandlerAttributes(testAttributes);
        Assertions.assertFalse((boolean)testSubject.isEmpty());
        Assertions.assertTrue((boolean)testSubject.contains(ATTRIBUTE_KEY));
        Assertions.assertEquals(testAttributes, (Object)testSubject.getAll());
    }

    @Test
    void get() {
        HashMap<String, Integer> testAttributes = new HashMap<String, Integer>();
        testAttributes.put(ATTRIBUTE_KEY, 42);
        SimpleHandlerAttributes testSubject = new SimpleHandlerAttributes(testAttributes);
        Assertions.assertEquals((int)42, (int)((Integer)testSubject.get(ATTRIBUTE_KEY)));
    }

    @Test
    void getAll() {
        HashMap<String, Integer> expectedAttributes = new HashMap<String, Integer>();
        expectedAttributes.put(ATTRIBUTE_KEY, 42);
        SimpleHandlerAttributes testSubject = new SimpleHandlerAttributes(expectedAttributes);
        Assertions.assertEquals(expectedAttributes, (Object)testSubject.getAll());
    }

    @Test
    void contains() {
        HashMap<String, Integer> expectedAttributes = new HashMap<String, Integer>();
        expectedAttributes.put(ATTRIBUTE_KEY, 42);
        SimpleHandlerAttributes testSubject = new SimpleHandlerAttributes(expectedAttributes);
        Assertions.assertTrue((boolean)testSubject.contains(ATTRIBUTE_KEY));
        Assertions.assertFalse((boolean)testSubject.contains("some-other-handler"));
    }

    @Test
    void mergedWith() {
        HashMap<String, Integer> testAttributes = new HashMap<String, Integer>();
        testAttributes.put(ATTRIBUTE_KEY, 42);
        HashMap<String, Integer> testOtherAttributes = new HashMap<String, Integer>();
        testOtherAttributes.put("some-other-key", 1729);
        SimpleHandlerAttributes testOther = new SimpleHandlerAttributes(testOtherAttributes);
        HashMap<String, Integer> expectedAttributes = new HashMap<String, Integer>();
        expectedAttributes.put(ATTRIBUTE_KEY, 42);
        expectedAttributes.put("some-other-key", 1729);
        SimpleHandlerAttributes testSubject = new SimpleHandlerAttributes(testAttributes);
        HandlerAttributes result = testSubject.mergedWith((HandlerAttributes)testOther);
        Assertions.assertEquals(expectedAttributes, (Object)result.getAll());
    }

    @Test
    void mergedWithReturnsThis() {
        HashMap<String, Integer> testAttributes = new HashMap<String, Integer>();
        testAttributes.put(ATTRIBUTE_KEY, 42);
        SimpleHandlerAttributes testSubject = new SimpleHandlerAttributes(testAttributes);
        Assertions.assertEquals((Object)testSubject, (Object)testSubject.mergedWith((HandlerAttributes)new SimpleHandlerAttributes(Collections.emptyMap())));
    }

    @Test
    void mergedWithReturnsAdditionalAttributes() {
        HashMap<String, Integer> testOtherAttributes = new HashMap<String, Integer>();
        testOtherAttributes.put(ATTRIBUTE_KEY, 42);
        SimpleHandlerAttributes testOther = new SimpleHandlerAttributes(testOtherAttributes);
        SimpleHandlerAttributes expected = new SimpleHandlerAttributes(testOtherAttributes);
        SimpleHandlerAttributes testSubject = new SimpleHandlerAttributes(Collections.emptyMap());
        Assertions.assertEquals((Object)expected, (Object)testSubject.mergedWith((HandlerAttributes)testOther));
    }
}

