/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.eventhandling.EventHandler;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.InterceptorChain;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.annotation.AnnotatedMessageHandlingMember;
import org.axonframework.messaging.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.annotation.MessageHandlingMember;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.messaging.interceptors.MessageHandlerInterceptor;
import org.axonframework.utils.MockException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.internal.util.collections.Sets;

class AnnotatedHandlerInspectorTest {
    private static ParameterResolverFactory parameterResolverFactory;
    private AnnotatedHandlerInspector<A> inspector;

    AnnotatedHandlerInspectorTest() {
    }

    @BeforeAll
    static void init() {
        parameterResolverFactory = ClasspathParameterResolverFactory.forClass(AnnotatedHandlerInspectorTest.class);
    }

    @BeforeEach
    void setUp() {
        this.inspector = AnnotatedHandlerInspector.inspectType(A.class, (ParameterResolverFactory)parameterResolverFactory, (HandlerDefinition)ClasspathHandlerDefinition.forClass(A.class), new HashSet<Class>(Arrays.asList(D.class, C.class)));
    }

    @Test
    void complexHandlerHierarchy() throws NoSuchMethodException {
        AnnotatedMessageHandlingMember paHandle = new AnnotatedMessageHandlingMember((Executable)pA.class.getMethod("paHandle", String.class), CommandMessage.class, String.class, parameterResolverFactory);
        AnnotatedMessageHandlingMember aHandle = new AnnotatedMessageHandlingMember((Executable)A.class.getMethod("aHandle", String.class), CommandMessage.class, String.class, parameterResolverFactory);
        AnnotatedMessageHandlingMember aOn = new AnnotatedMessageHandlingMember((Executable)A.class.getMethod("aOn", Integer.class), EventMessage.class, Integer.class, parameterResolverFactory);
        AnnotatedMessageHandlingMember bHandle = new AnnotatedMessageHandlingMember((Executable)B.class.getMethod("bHandle", Boolean.class), CommandMessage.class, Boolean.class, parameterResolverFactory);
        AnnotatedMessageHandlingMember bOn = new AnnotatedMessageHandlingMember((Executable)B.class.getMethod("bOn", Long.class), EventMessage.class, Long.class, parameterResolverFactory);
        AnnotatedMessageHandlingMember cHandle = new AnnotatedMessageHandlingMember((Executable)C.class.getMethod("cHandle", Boolean.class), CommandMessage.class, Boolean.class, parameterResolverFactory);
        AnnotatedMessageHandlingMember cOn = new AnnotatedMessageHandlingMember((Executable)C.class.getMethod("cOn", Integer.class), EventMessage.class, Integer.class, parameterResolverFactory);
        AnnotatedMessageHandlingMember dHandle = new AnnotatedMessageHandlingMember((Executable)D.class.getMethod("dHandle", String.class), CommandMessage.class, String.class, parameterResolverFactory);
        Map allHandlers = this.inspector.getAllHandlers();
        Assertions.assertEquals((int)5, (int)allHandlers.size());
        Assertions.assertEquals((Object)paHandle, ((MessageHandlingMember)((SortedSet)allHandlers.get(pA.class)).first()).unwrap(AnnotatedMessageHandlingMember.class).get());
        Assertions.assertEquals((Object)paHandle, this.inspector.getHandlers(pA.class).findFirst().flatMap(h -> h.unwrap(AnnotatedMessageHandlingMember.class)).get());
        Assertions.assertEquals(Arrays.asList(aOn, aHandle, paHandle), this.unwrapToList(((SortedSet)allHandlers.get(A.class)).stream()));
        Assertions.assertEquals(Arrays.asList(aOn, aHandle, paHandle), this.unwrapToList(this.inspector.getHandlers(A.class)));
        Assertions.assertEquals(Arrays.asList(aOn, bOn, aHandle, bHandle, paHandle), this.unwrapToList(((SortedSet)allHandlers.get(B.class)).stream()));
        Assertions.assertEquals(Arrays.asList(aOn, bOn, aHandle, bHandle, paHandle), this.unwrapToList(this.inspector.getHandlers(B.class)));
        Assertions.assertEquals(Arrays.asList(aOn, cOn, aHandle, cHandle, paHandle), this.unwrapToList(((SortedSet)allHandlers.get(C.class)).stream()));
        Assertions.assertEquals(Arrays.asList(aOn, cOn, aHandle, cHandle, paHandle), this.unwrapToList(this.inspector.getHandlers(C.class)));
        Assertions.assertEquals(Arrays.asList(aOn, bOn, aHandle, bHandle, dHandle, paHandle), this.unwrapToList(((SortedSet)allHandlers.get(D.class)).stream()));
        Assertions.assertEquals(Arrays.asList(aOn, bOn, aHandle, bHandle, dHandle, paHandle), this.unwrapToList(this.inspector.getHandlers(D.class)));
    }

    @Test
    void doesNotRegisterAbstractHandlersTwice() {
        AnnotatedHandlerInspector aaInspector = AnnotatedHandlerInspector.inspectType(AB.class, (ParameterResolverFactory)parameterResolverFactory);
        Assertions.assertEquals((int)1, (int)aaInspector.getAllHandlers().size());
        Assertions.assertEquals((int)1, (int)((int)aaInspector.getAllHandlers().values().stream().flatMap(Collection::stream).count()));
    }

    private <T extends MessageHandlingMember<?>> List<AnnotatedMessageHandlingMember<?>> unwrapToList(Stream<T> stream) {
        return stream.map(e -> e.unwrap(AnnotatedMessageHandlingMember.class).map(handler -> handler).get()).collect(Collectors.toList());
    }

    @Test
    void interceptors() throws Exception {
        D testTarget = new D();
        EventMessage testEvent = GenericEventMessage.asEventMessage((Object)"Hello");
        EventMessage testEventTwo = GenericEventMessage.asEventMessage((Object)1);
        Map interceptors = this.inspector.getAllInterceptors();
        Assertions.assertEquals((int)5, (int)interceptors.size());
        Assertions.assertEquals((int)1, (int)((SortedSet)interceptors.get(pA.class)).size());
        Assertions.assertEquals((int)1, (int)((SortedSet)interceptors.get(A.class)).size());
        Assertions.assertEquals((int)2, (int)((SortedSet)interceptors.get(B.class)).size());
        Assertions.assertEquals((int)1, (int)((SortedSet)interceptors.get(C.class)).size());
        Assertions.assertEquals((int)2, (int)((SortedSet)interceptors.get(D.class)).size());
        MessageHandlerInterceptorMemberChain chain = this.inspector.chainedInterceptor(B.class);
        Optional optionalHandler = this.inspector.getHandlers(pA.class).findFirst();
        Assertions.assertTrue((boolean)optionalHandler.isPresent());
        MessageHandlingMember resultHandler = (MessageHandlingMember)optionalHandler.get();
        chain.handle((Message)testEvent, (Object)testTarget, resultHandler);
        Assertions.assertThrows(MockException.class, () -> chain.handle((Message)testEventTwo, (Object)testTarget, resultHandler));
    }

    @Test
    void getAllInspectedTypes() {
        Set expectedInspectedTypes = Sets.newSet((Object[])new Class[]{pA.class, A.class, B.class, C.class, D.class});
        Set resultInspectedTypes = this.inspector.getAllInspectedTypes();
        resultInspectedTypes.forEach(resultType -> Assertions.assertTrue((boolean)expectedInspectedTypes.contains(resultType)));
        expectedInspectedTypes.forEach(expectedType -> Assertions.assertTrue((boolean)resultInspectedTypes.contains(expectedType)));
    }

    public static class AB
    extends AA {
        @Override
        public String handleAbstractly(String command) {
            return "Some result";
        }
    }

    public static abstract class AA {
        @CommandHandler
        public abstract String handleAbstractly(String var1);
    }

    private static class D
    extends B {
        private D() {
        }

        @CommandHandler
        public void dHandle(String d) {
        }
    }

    private static class C
    extends A {
        private C() {
        }

        @CommandHandler
        public void cHandle(Boolean a) {
        }

        @EventHandler
        public void cOn(Integer a) {
        }
    }

    private static class B
    extends A {
        private B() {
        }

        @CommandHandler
        public void bHandle(Boolean a) {
        }

        @EventHandler
        public void bOn(Long b) {
        }

        @MessageHandlerInterceptor
        public void intercept(Integer e, InterceptorChain chain) {
            throw new MockException("Faking exception in interceptor");
        }
    }

    private static class A
    extends pA {
        private A() {
        }

        @CommandHandler
        public void aHandle(String a) {
        }

        @EventHandler
        public void aOn(Integer a) {
        }
    }

    private static class pA {
        private pA() {
        }

        @CommandHandler
        public void paHandle(String a) {
        }

        @MessageHandlerInterceptor
        public void intercept(String e) {
        }
    }
}

