/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotation;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.NoScopeDescriptor;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.messaging.annotation.ParameterResolver;
import org.axonframework.messaging.annotation.ScopeDescriptorParameterResolverFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ScopeDescriptorParameterResolverFactoryTest {
    private final ScopeDescriptorParameterResolverFactory testSubject = new ScopeDescriptorParameterResolverFactory();
    private Method scopeDescriptorLessMethod;
    private Method scopeDescriptorUsingMethod;
    private Message<?> testMessage;

    ScopeDescriptorParameterResolverFactoryTest() {
    }

    @BeforeEach
    void setUp() throws NoSuchMethodException {
        this.scopeDescriptorUsingMethod = this.getClass().getMethod("someScopeDescriptorUsingMethod", ScopeDescriptor.class);
        this.scopeDescriptorLessMethod = this.getClass().getMethod("someScopeDescriptorLessMethod", String.class);
        this.testMessage = (Message)Mockito.mock(Message.class);
    }

    @Test
    void parameterResolverIsNullForScopeDescriptorLessMethod() {
        Assertions.assertNull((Object)this.testSubject.createInstance((Executable)this.scopeDescriptorLessMethod, this.scopeDescriptorLessMethod.getParameters(), 0));
    }

    @Test
    void resolvesNoScopeDescriptor() {
        ParameterResolver resolver = this.testSubject.createInstance((Executable)this.scopeDescriptorUsingMethod, this.scopeDescriptorUsingMethod.getParameters(), 0);
        Assertions.assertTrue((boolean)resolver.matches(this.testMessage));
        Assertions.assertEquals((Object)NoScopeDescriptor.INSTANCE, (Object)resolver.resolveParameterValue(this.testMessage));
    }

    public void someScopeDescriptorLessMethod(String s) {
    }

    public void someScopeDescriptorUsingMethod(ScopeDescriptor scopeDescriptor) {
    }
}

