/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.Decisions;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.Ignore;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class IgnoreTest {
    private DeadLetter<EventMessage<String>> testLetter;

    IgnoreTest() {
    }

    @BeforeEach
    void setUp() {
        GenericDeadLetter.clock = Clock.fixed(Instant.now(), ZoneId.systemDefault());
        this.testLetter = new GenericDeadLetter((Object)"seqId", (Message)GenericEventMessage.asEventMessage((Object)"payload"));
    }

    @Test
    void constructorIgnoreAllowsEnqueueing() {
        Ignore testSubject = new Ignore();
        Assertions.assertTrue((boolean)testSubject.shouldEnqueue());
        Assertions.assertFalse((boolean)testSubject.enqueueCause().isPresent());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals(this.testLetter, (Object)result);
    }

    @Test
    void decisionsIgnoreAllowsEnqueueing() {
        Ignore testSubject = Decisions.ignore();
        Assertions.assertTrue((boolean)testSubject.shouldEnqueue());
        Assertions.assertFalse((boolean)testSubject.enqueueCause().isPresent());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals(this.testLetter, (Object)result);
    }
}

