/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.deadletter.DeadLetter;
import org.axonframework.messaging.deadletter.Decisions;
import org.axonframework.messaging.deadletter.GenericDeadLetter;
import org.axonframework.messaging.deadletter.ShouldEnqueue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ShouldEnqueueTest {
    private DeadLetter<? extends Message<?>> testLetter;

    ShouldEnqueueTest() {
    }

    @BeforeEach
    void setUp() {
        GenericDeadLetter.clock = Clock.fixed(Instant.now(), ZoneId.systemDefault());
        this.testLetter = new GenericDeadLetter((Object)"seqId", (Message)GenericEventMessage.asEventMessage((Object)"payload"));
    }

    @Test
    void constructorShouldEnqueueAllowsEnqueueing() {
        ShouldEnqueue testSubject = new ShouldEnqueue();
        Assertions.assertTrue((boolean)testSubject.shouldEnqueue());
        Assertions.assertFalse((boolean)testSubject.enqueueCause().isPresent());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals(this.testLetter, (Object)result);
    }

    @Test
    void decisionsEnqueueAllowsEnqueueing() {
        ShouldEnqueue testSubject = Decisions.enqueue();
        Assertions.assertTrue((boolean)testSubject.shouldEnqueue());
        Assertions.assertFalse((boolean)testSubject.enqueueCause().isPresent());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals(this.testLetter, (Object)result);
    }

    @Test
    void constructorShouldEnqueueWithCauseAllowsEnqueueingWithGivenCause() {
        RuntimeException testCause = new RuntimeException("just because");
        ShouldEnqueue testSubject = new ShouldEnqueue((Throwable)testCause);
        Assertions.assertTrue((boolean)testSubject.shouldEnqueue());
        Optional resultCause = testSubject.enqueueCause();
        Assertions.assertTrue((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)testCause, resultCause.get());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals(this.testLetter, (Object)result);
    }

    @Test
    void decisionsEnqueueWithCauseAllowsEnqueueingWithGivenCause() {
        RuntimeException testCause = new RuntimeException("just because");
        ShouldEnqueue testSubject = Decisions.enqueue((Throwable)testCause);
        Assertions.assertTrue((boolean)testSubject.shouldEnqueue());
        Optional resultCause = testSubject.enqueueCause();
        Assertions.assertTrue((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)testCause, resultCause.get());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals(this.testLetter, (Object)result);
    }

    @Test
    void decisionsRequeueWithCauseAllowsEnqueueingWithGivenCause() {
        RuntimeException testCause = new RuntimeException("just because");
        ShouldEnqueue testSubject = Decisions.requeue((Throwable)testCause);
        Assertions.assertTrue((boolean)testSubject.shouldEnqueue());
        Optional resultCause = testSubject.enqueueCause();
        Assertions.assertTrue((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)testCause, resultCause.get());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals(this.testLetter, (Object)result);
    }

    @Test
    void constructorShouldEnqueueWithCauseAndDiagnosticsAllowsEnqueueingWithGivenCauseAndDiagnostics() {
        RuntimeException testCause = new RuntimeException("just because");
        MetaData testMetaData = MetaData.with((String)"key", (Object)"value");
        ShouldEnqueue testSubject = new ShouldEnqueue((Throwable)testCause, letter -> testMetaData);
        Assertions.assertTrue((boolean)testSubject.shouldEnqueue());
        Optional resultCause = testSubject.enqueueCause();
        Assertions.assertTrue((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)testCause, resultCause.get());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals((Object)this.testLetter.message(), (Object)result.message());
        Assertions.assertEquals((Object)this.testLetter.cause(), (Object)result.cause());
        Assertions.assertEquals((Object)this.testLetter.enqueuedAt(), (Object)result.enqueuedAt());
        Assertions.assertEquals((Object)this.testLetter.lastTouched(), (Object)result.lastTouched());
        Assertions.assertEquals((Object)testMetaData, (Object)result.diagnostics());
    }

    @Test
    void decisionsRequeueWithCauseAndDiagnosticsAllowsEnqueueingWithGivenCauseAndDiagnostics() {
        RuntimeException testCause = new RuntimeException("just because");
        MetaData testMetaData = MetaData.with((String)"key", (Object)"value");
        ShouldEnqueue testSubject = Decisions.requeue((Throwable)testCause, letter -> testMetaData);
        Assertions.assertTrue((boolean)testSubject.shouldEnqueue());
        Optional resultCause = testSubject.enqueueCause();
        Assertions.assertTrue((boolean)resultCause.isPresent());
        Assertions.assertEquals((Object)testCause, resultCause.get());
        DeadLetter result = testSubject.withDiagnostics(this.testLetter);
        Assertions.assertEquals((Object)this.testLetter.message(), (Object)result.message());
        Assertions.assertEquals((Object)this.testLetter.cause(), (Object)result.cause());
        Assertions.assertEquals((Object)this.testLetter.enqueuedAt(), (Object)result.enqueuedAt());
        Assertions.assertEquals((Object)this.testLetter.lastTouched(), (Object)result.lastTouched());
        Assertions.assertEquals((Object)testMetaData, (Object)result.diagnostics());
    }
}

