/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.deadletter;

import org.axonframework.messaging.deadletter.ThrowableCause;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ThrowableCauseTest {
    private static final String BLOB_OF_TEXT = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Gravida quis blandit turpis cursus in. Nulla facilisi etiam dignissim diam quis enim lobortis scelerisque fermentum. Egestas maecenas pharetra convallis posuere morbi leo urna. Dictumst quisque sagittis purus sit amet volutpat consequat. At volutpat diam ut venenatis tellus in metus vulputate eu. Imperdiet dui accumsan sit amet nulla facilisi. Eget est lorem ipsum dolor sit amet. Vestibulum morbi blandit cursus risus at ultrices mi tempus imperdiet. Sed tempus urna et pharetra pharetra massa massa. Dolor magna eget est lorem. Purus semper eget duis at tellus. Tincidunt augue interdum velit euismod in pellentesque massa placerat duis.\n\nQuis ipsum suspendisse ultrices gravida dictum fusce ut. Nascetur ridiculus mus mauris vitae ultricies leo integer malesuada. Sit amet purus gravida quis blandit turpis cursus in. Gravida rutrum quisque non tellus. Eros donec ac odio tempor orci dapibus. Dictum varius duis at consectetur lorem donec massa sapien.Tincidunt arcu non sodales neque sodales ut etiam sit amet. Sagittis aliquam malesuada bibendum arcu vitae. Vel turpis nunc eget lorem dolor sed viverra. In egestas erat imperdiet sed euismod nisi. Lorem ipsum dolor sit amet consectetur.";

    ThrowableCauseTest() {
    }

    @Test
    void constructThrowableCauseWithThrowable() {
        RuntimeException testThrowable = new RuntimeException("some-message");
        ThrowableCause testSubject = new ThrowableCause((Throwable)testThrowable);
        Assertions.assertEquals((Object)testThrowable.getClass().getName(), (Object)testSubject.type());
        Assertions.assertEquals((Object)testThrowable.getMessage(), (Object)testSubject.message());
    }

    @Test
    void constructThrowableCauseWithTypeAndMessage() {
        String testType = "type";
        String testMessage = "message";
        ThrowableCause testSubject = new ThrowableCause(testType, testMessage);
        Assertions.assertEquals((Object)testType, (Object)testSubject.type());
        Assertions.assertEquals((Object)testMessage, (Object)testSubject.message());
    }

    @Test
    void asCauseWrapsThrowable() {
        RuntimeException testThrowable = new RuntimeException("some-message");
        ThrowableCause result = ThrowableCause.asCause((Throwable)testThrowable);
        Assertions.assertEquals((Object)testThrowable.getClass().getName(), (Object)result.type());
        Assertions.assertEquals((Object)testThrowable.getMessage(), (Object)result.message());
    }

    @Test
    void asCauseReturnsCauseAsIs() {
        ThrowableCause testCause = new ThrowableCause("type", "message");
        ThrowableCause result = ThrowableCause.asCause((Throwable)testCause);
        Assertions.assertEquals((Object)testCause, (Object)result);
    }

    @Test
    void truncateLeavesMessageAsIsIfItDoesNotExceedMessageSize() {
        RuntimeException testThrowable = new RuntimeException("some-message");
        ThrowableCause result = ThrowableCause.truncated((Throwable)testThrowable);
        Assertions.assertEquals((Object)testThrowable.getClass().getName(), (Object)result.type());
        Assertions.assertEquals((Object)testThrowable.getMessage(), (Object)result.message());
    }

    @Test
    void truncateCanHandleNullMessages() {
        RuntimeException testThrowable = new RuntimeException();
        ThrowableCause result = ThrowableCause.truncated((Throwable)testThrowable);
        Assertions.assertEquals((Object)testThrowable.getClass().getName(), (Object)result.type());
        Assertions.assertNull((Object)result.message());
    }

    @Test
    void truncateShortensMessageIfItExceedsMessageSize() {
        String textThatShouldBeTruncated = "truncated-text-at-the-end";
        RuntimeException testThrowable = new RuntimeException(BLOB_OF_TEXT + textThatShouldBeTruncated);
        ThrowableCause result = ThrowableCause.truncated((Throwable)testThrowable);
        Assertions.assertEquals((Object)testThrowable.getClass().getName(), (Object)result.type());
        Assertions.assertNotEquals((Object)testThrowable.getMessage(), (Object)result.getMessage());
        Assertions.assertFalse((boolean)result.getMessage().contains(textThatShouldBeTruncated));
    }

    @Test
    void truncateWithSpecifiedMessageSizeLeavesMessageAsIsIfItDoesNotExceedGivenSize() {
        String testMessage = "some-message";
        RuntimeException testThrowable = new RuntimeException(testMessage);
        ThrowableCause result = ThrowableCause.truncated((Throwable)testThrowable, (int)testMessage.length());
        Assertions.assertEquals((Object)testThrowable.getClass().getName(), (Object)result.type());
        Assertions.assertEquals((Object)testThrowable.getMessage(), (Object)result.message());
    }

    @Test
    void truncateWithSpecifiedMessageSizeShortensMessageIfItExceedsGivenSize() {
        String textThatShouldBeTruncated = "truncated-text-at-the-end";
        RuntimeException testThrowable = new RuntimeException(textThatShouldBeTruncated);
        int testMessageSize = textThatShouldBeTruncated.length() - 3;
        ThrowableCause result = ThrowableCause.truncated((Throwable)testThrowable, (int)testMessageSize);
        Assertions.assertEquals((Object)testThrowable.getClass().getName(), (Object)result.type());
        Assertions.assertNotEquals((Object)testThrowable.getMessage(), (Object)result.getMessage());
        Assertions.assertFalse((boolean)result.getMessage().contains(textThatShouldBeTruncated));
        Assertions.assertTrue((boolean)result.getMessage().contains(textThatShouldBeTruncated.substring(0, testMessageSize)));
    }
}

