/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.responsetypes;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractResponseTypeTest<R> {
    protected static final Integer MATCHES = 1;
    protected static final Integer DOES_NOT_MATCH = 0;
    protected final ResponseType<R> testSubject;

    protected AbstractResponseTypeTest(ResponseType<R> testSubject) {
        this.testSubject = testSubject;
    }

    protected void testMatchRanked(String methodNameToTest, Integer expectedResult) throws NoSuchMethodException {
        Method methodToTest = ReflectionUtils.methodOf(this.getClass(), (String)methodNameToTest, (Class[])new Class[0]);
        Type methodReturnType = methodToTest.getGenericReturnType();
        Assertions.assertEquals((Integer)expectedResult, (Integer)this.testSubject.matchRank(methodReturnType));
        Assertions.assertEquals((Object)(expectedResult > 0 ? 1 : 0), (Object)this.testSubject.matches(methodReturnType));
    }

    public QueryResponse someQuery() {
        return new QueryResponse();
    }

    public SubTypedQueryResponse someSubTypedQuery() {
        return new SubTypedQueryResponse();
    }

    public Object someSuperTypedQuery() {
        return new Object();
    }

    public <E> E someUnboundedGenericQuery() {
        return (E)new SubTypedQueryResponse();
    }

    public <E extends QueryResponse> E someBoundedGenericQuery() {
        return (E)new SubTypedQueryResponse();
    }

    public <E extends SubTypedQueryResponse> E someMultiBoundedGenericQuery() {
        return (E)new ComplexTypedQueryResponse();
    }

    public <E extends QueryResponseInterface> E someNonMatchingBoundedGenericQuery() {
        return (E)new QueryResponseInterface(){};
    }

    public QueryResponse[] someArrayQuery() {
        return new QueryResponse[0];
    }

    public SubTypedQueryResponse[] someSubTypedArrayQuery() {
        return new SubTypedQueryResponse[0];
    }

    public Object[] someSuperTypedArrayQuery() {
        return new Object[0];
    }

    public <E> E[] someUnboundedGenericArrayQuery() {
        return new SubTypedQueryResponse[0];
    }

    public <E extends QueryResponse> E[] someBoundedGenericArrayQuery() {
        return new SubTypedQueryResponse[0];
    }

    public <E extends SubTypedQueryResponse> E[] someMultiBoundedGenericArrayQuery() {
        return new ComplexTypedQueryResponse[0];
    }

    public <E extends QueryResponseInterface> E[] someNonMatchingBoundedGenericArrayQuery() {
        return (QueryResponseInterface[])new SubTypedQueryResponse[0];
    }

    public List<QueryResponse> someListQuery() {
        return new ArrayList<QueryResponse>();
    }

    public List<SubTypedQueryResponse> someSubListQuery() {
        return new ArrayList<SubTypedQueryResponse>();
    }

    public List<Object> someSuperListQuery() {
        return new ArrayList<Object>();
    }

    public <E extends QueryResponse> List<E> someBoundedGenericListQuery() {
        return new ArrayList();
    }

    public <E> List<E> someUnboundedGenericListQuery() {
        return new ArrayList();
    }

    public <E extends SubTypedQueryResponse> List<E> someMultiBoundedGenericListQuery() {
        return new ArrayList();
    }

    public <E extends QueryResponseInterface> List<E> someNonMatchingBoundedGenericListQuery() {
        return new ArrayList();
    }

    public List<?> someUnboundedWildcardListQuery() {
        return new ArrayList();
    }

    public List<? super QueryResponse> someLowerBoundedWildcardListQuery() {
        return new ArrayList();
    }

    public List<? extends SubTypedQueryResponse> someUpperBoundedWildcardListQuery() {
        return new ArrayList();
    }

    public List<? extends QueryResponseInterface> someNonMatchingUpperBoundedWildcardQuery() {
        return new ArrayList();
    }

    public <E> List<? extends E> someUnboundedGenericUpperBoundedWildcardListQuery() {
        return new ArrayList();
    }

    public <E extends SubTypedQueryResponse> List<? extends E> someGenericUpperBoundedWildcardListQuery() {
        return new ArrayList();
    }

    public <E extends SubTypedQueryResponse> List<? extends E> someMultiGenericUpperBoundedWildcardListQuery() {
        return new ArrayList();
    }

    public <E> UnboundQueryResponseList<E> someUnboundedListImplementationQuery() {
        return new UnboundQueryResponseList();
    }

    public <E extends QueryResponse> BoundQueryResponseList<E> someBoundedListImplementationQuery() {
        return new BoundQueryResponseList();
    }

    public <E, R> MultiUnboundQueryResponseList<E, R> someMultiUnboundedListImplementationQuery() {
        return new MultiUnboundQueryResponseList();
    }

    public <E extends QueryResponse, R> MultiBoundQueryResponseList<E, R> someMultiBoundedListImplementationQuery() {
        return new MultiBoundQueryResponseList();
    }

    public Set<QueryResponse> someSetQuery() {
        return new HashSet<QueryResponse>();
    }

    public Stream<QueryResponse> someStreamQuery() {
        return Stream.of(new QueryResponse());
    }

    public Map<QueryResponse, QueryResponse> someMapQuery() {
        return new HashMap<QueryResponse, QueryResponse>();
    }

    public Future<QueryResponse> someFutureQuery() {
        return CompletableFuture.completedFuture(new QueryResponse());
    }

    public Future<List<QueryResponse>> someFutureListQuery() {
        return CompletableFuture.completedFuture(Collections.singletonList(new QueryResponse()));
    }

    public Optional<QueryResponse> someOptionalQueryResponse() {
        return Optional.of(new QueryResponse());
    }

    private static class MultiBoundQueryResponseList<E extends QueryResponse, R>
    extends ArrayList<E> {
        private MultiBoundQueryResponseList() {
        }
    }

    private static class MultiUnboundQueryResponseList<E, R>
    extends ArrayList<E> {
        private MultiUnboundQueryResponseList() {
        }
    }

    private static class BoundQueryResponseList<E extends QueryResponse>
    extends ArrayList<E> {
        private BoundQueryResponseList() {
        }
    }

    private static class UnboundQueryResponseList<E>
    extends ArrayList<E> {
        private UnboundQueryResponseList() {
        }
    }

    private static class ComplexTypedQueryResponse
    extends SubTypedQueryResponse
    implements QueryResponseInterface {
        private ComplexTypedQueryResponse() {
        }
    }

    static interface QueryResponseInterface {
    }

    static class SubTypedQueryResponse
    extends QueryResponse {
        SubTypedQueryResponse() {
        }
    }

    static class QueryResponse {
        QueryResponse() {
        }
    }
}

